% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colsMean.R
\name{colsMean}
\alias{colsMean}
\title{Compute Row-wise Means for Groups of Columns}
\usage{
colsMean(x, ncols)
}
\arguments{
\item{x}{A numeric matrix or data frame.}

\item{ncols}{An integer specifying the number of consecutive columns to group together.}
}
\value{
A numeric matrix with the same number of rows as \code{x} and \code{ncol(x) / ncols} columns,
  where each column is the row-wise mean of a group of \code{ncols} columns.
}
\description{
This function computes the row-wise mean for consecutive groups of columns in a matrix or data frame.
}
\details{
The function splits the columns of \code{x} into consecutive groups of \code{ncols} columns
and calculates the mean of each row for each group. The number of columns in \code{x} must
be divisible by \code{ncols}.
}
\examples{
mat <- matrix(1:12, nrow = 3)
colsMean(mat, 2)

}
