% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power.prop.test.R
\name{power_prop_test}
\alias{power_prop_test}
\title{Power Calculations for Two-Sample Test for Proportions with unequal sample size}
\usage{
power_prop_test(
  n = NULL,
  p1 = NULL,
  p2 = NULL,
  sig.level = 0.05,
  power = NULL,
  ratio = 1,
  alternative = c("two.sided", "one.sided"),
  tol = .Machine$double.eps^0.25
)
}
\arguments{
\item{n}{Number of observations (in group 1)}

\item{p1}{Probability in one group}

\item{p2}{Probability in other group}

\item{sig.level}{Significance level (Type I error probability)}

\item{power}{Power of test (1 minus Type II error probability)}

\item{ratio}{The ratio n2/n1 between the larger group and the smaller group. Should be a value equal to or greater than 1 since n2 is the larger group. Defaults to 1 (equal group sizes)}

\item{alternative}{String. Can be one- or two-sided test. Can be abbreviated.}

\item{tol}{Numerical tolerance used in root finding, the default providing (at least) four significant digits}
}
\value{
Object of class \code{power.htest}, a list of the arguments (including the computed one) augmented with \code{method} and \code{note} elements.
}
\description{
Compute power of test, or determine parameters to obtain target
power for equal and unequal sample sizes.
}
\details{
Exactly one of the parameters \code{n}, \code{delta}, \code{power}, \code{sd}, \code{sig.level}, \code{ratio} \code{sd.ratio}
must be passed as NULL, and that parameter is determined from the others. Notice that the last two have non-NULL defaults
so NULL must be explicitly passed if you want to compute them.
}
\note{
\code{uniroot} is used to solve power equation for unknowns, so you may
see errors from it, notably about inability to bracket the root
when invalid arguments are given.
}
\examples{
power_prop_test(n=NULL, p1=.65, p2=.85, power=.8, ratio=2)
}
\seealso{
\code{\link{power.prop.test}}, \code{\link{power_t_test}}, \code{\link{power.t.test}}
}
\author{
Claus Ekstrom \email{claus@rprimer.dk}
}
\keyword{htest}
