% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{pairwise_distance_correlation}
\alias{pairwise_distance_correlation}
\title{Compute pairwise distance correlation metrics of each column to a vector}
\usage{
pairwise_distance_correlation(x, y)
}
\arguments{
\item{x}{A matrix. The number of rows should match the length of the vector y}

\item{y}{A vector}
}
\value{
A vector with the same length as the number of columns in x. Each element contains the pairwise distance correlation to y.
}
\description{
Fast computation of pairwise distance correlations.
}
\details{
Note: To get the same result as from the energy package you need to take the square root of the results here.
}
\examples{
y <- rnorm(100)
x <- matrix(rnorm(100 * 10), ncol = 10)
pairwise_distance_correlation(x, y)

}
\author{
Claus Ekstrom <claus@rprimer.dk>
}
