% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{pairwise_combination_indices}
\alias{pairwise_combination_indices}
\title{Compute all pairwise combinations of indices}
\usage{
pairwise_combination_indices(n, self = FALSE)
}
\arguments{
\item{n}{A number giving the number of elements to create all pairwise indices from}

\item{self}{A logical that determines whether a column should also be multiplied by itself.}
}
\value{
A matrix with n*(n+1)/2 rows (if self=TRUE) or n*(n-1)/2 rows (if self=FALSE, the default) and two columns gicing all possible combinations of indices.
}
\description{
Fast computation of indices of all pairwise element of a vector of length n.
}
\details{
Note that the output order of columns corresponds to the order of the columns in x. First column 1 is multiplied with each of the other columns, then column 2 with the remaining columns etc.
}
\examples{

pairwise_combination_indices(3)
pairwise_combination_indices(4, self=TRUE)

}
\author{
Claus Ekstrom <claus@rprimer.dk>
}
