% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chisq_test.R
\name{monte_carlo_chisq_test}
\alias{monte_carlo_chisq_test}
\title{Two-sided table test with fixed margins}
\usage{
monte_carlo_chisq_test(x, margin = c("N", "rows", "both"), B = 100000L)
}
\arguments{
\item{x}{A matrix representing the contingency table.}

\item{margin}{A string that determines which margin is fixed: Either "N" for the total number of observations (the default), "rows" for fixed row sums, and "both" for simultaneously fixed row and column sums.}

\item{B}{The number of simulations used to compute the p-value.}
}
\value{
A list of class "htest" giving the simulation results.
}
\description{
Monte Carlo test in a two-way contingency table with the total number of observations fixed, row margin fixed, or both margins fixed.
}
\details{
Simulation is done by random sampling from the set of all tables with given marginal(s), and works only if the relevant marginal(s) are strictly positive. Continuity correction is never used, and the statistic is quoted without it.
}
\examples{

m <- matrix(c(12, 4, 8, 6), 2)
chisq.test(m)
chisq.test(m, correct=FALSE)
monte_carlo_chisq_test(m)

fisher.test(m)
monte_carlo_chisq_test(m, margin="both")

m2 <- matrix(c(9, 3, 3, 7), 2)
monte_carlo_chisq_test(m, margin="N")
monte_carlo_chisq_test(m, margin="both") 

}
\author{
Claus Ekstrom <claus@rprimer.dk>
}
\keyword{manip}
