% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLR-predict.R
\name{residuals.PLR}
\alias{residuals.PLR}
\alias{residuals.PLR_boot}
\alias{residuals.PLR_cv}
\title{Residuals for the penalized Lorenz regression}
\usage{
\method{residuals}{PLR}(object, pars.idx = "BIC", ...)
}
\arguments{
\item{object}{An object of class \code{"PLR"}.}

\item{pars.idx}{What grid and penalty parameters should be used for parameter selection. Either a character string specifying the selection method, where the possible values are:
\itemize{
   \item \code{"BIC"} (default) - Always available.
   \item \code{"Boot"} - Available if \code{object} inherits from \code{"PLR_boot"}.
   \item \code{"CV"} - Available if \code{object} inherits from \code{"PLR_cv"}.
}
Or a numeric vector of length 2, where the first element is the index of the grid parameter and the second is the index of the penalty parameter.}

\item{...}{Additional arguments passed to the function \code{\link{Rearrangement.estimation}}.}
}
\value{
A vector of residuals.
}
\description{
\code{residuals} provides residuals for an object of class \code{"PLR"}.
}
\details{
Computing residuals entail to estimate the link function of the single-index model. This is done via the function \code{\link{Rearrangement.estimation}}.
}
\examples{
## For examples see example(Lorenz.Reg), example(Lorenz.boot) and example(PLR.CV)

}
\seealso{
\code{\link{Lorenz.Reg}}, \code{\link{Rearrangement.estimation}}
}
