% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.R
\name{bootstrap_lss}
\alias{bootstrap_lss}
\title{[experimental] Compute polarity scores with different hyper-parameters}
\usage{
bootstrap_lss(
  x,
  what = c("seeds", "k"),
  mode = c("terms", "coef", "predict"),
  remove = FALSE,
  from = 100,
  to = NULL,
  by = 50,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{x}{a fitted textmodel_lss object.}

\item{what}{choose the hyper-parameter to resample in bootstrapping.}

\item{mode}{choose the type of the result of bootstrapping. If \code{coef},
returns the polarity scores of words; if \code{terms}, returns words sorted by
the polarity scores in descending order; if \code{predict}, returns the polarity
scores of documents.}

\item{remove}{if \code{TRUE}, remove each seed word when \code{what = "seeds"}.}

\item{from, to, by}{passed to \code{seq()} to generate values for \code{k}; only used
when \code{what = "k"}.}

\item{verbose}{show messages if \code{TRUE}.}

\item{...}{additional arguments passed to \code{\link[=as.textmodel_lss]{as.textmodel_lss()}} and
\code{\link[=predict]{predict()}}.}
}
\description{
A function to compute polarity scores of words and documents by resampling
hyper-parameters from a fitted LSS model.
}
\details{
\code{bootstrap_lss()} creates LSS fitted textmodel_lss objects internally by
resampling hyper-parameters and computes polarity of words or documents.
The resulting matrix can be used to asses the validity and the reliability
of seeds or k.

Note that the objects created by \code{\link[=as.textmodel_lss]{as.textmodel_lss()}} does not contain data, users
must pass \code{newdata} via \code{...} when \code{mode = "predict"}.
}
