#' Subset Dataset for Training the Pre-Trained Long Short Term Memory (LSTM) Network
#'
#' @description
#' This dataset is a subset of the full datasets, consisting of 1,000 samples
#' from the original 1,000,000-sample datasets.
#'
#' @format A 1,000×21 matrix, where the firt column represents the labels and
#' the last 20 columns represent feature values, which correspond to the number of
#' factors associated with the features.
#'
#' @seealso \link[LSTMfactors]{LSTM}, \link[LSTMfactors]{load.scaler}, \link[LSTMfactors]{data.scaler.LSTM}, \link[LSTMfactors]{normalizor}
#'
#' @note
#' Methods for generating and extracting features from the dataset can be found in \link[LSTMfactors]{LSTM}.
#'
#' @examples
#' data(data.datasets.LSTM)
#' head(data.datasets.LSTM)
#'
#' @docType data
#' @name data.datasets.LSTM
NULL
