% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{japan_universities_tbl_df}
\alias{japan_universities_tbl_df}
\title{Japanese Universities}
\format{
A tibble with 813 observations and 22 variables:
\describe{
  \item{...1}{Index column (numeric)}
  \item{code}{University code (character)}
  \item{name}{University name in English (character)}
  \item{name_jp}{University name in Japanese (character)}
  \item{type}{Type of university (e.g., Public, Private) (character)}
  \item{type_jp}{Type of university in Japanese (character)}
  \item{address}{Full address of the university (character)}
  \item{postal_code}{Postal code (character)}
  \item{phone}{Contact phone number (character)}
  \item{state}{Name of the prefecture or region in English (character)}
  \item{state_jp}{Name of the prefecture or region in Japanese (character)}
  \item{latitude}{Latitude coordinate (numeric)}
  \item{longitude}{Longitude coordinate (numeric)}
  \item{found}{Year the university was founded (character)}
  \item{faculty_count}{Number of faculties (numeric)}
  \item{department_count}{Number of departments (numeric)}
  \item{has_grad}{Whether the university has graduate programs (logical)}
  \item{has_remote}{Whether the university offers remote programs (logical)}
  \item{review_rating}{Average user review rating (numeric)}
  \item{review_count}{Number of user reviews (numeric)}
  \item{difficulty_SD}{Standard deviation of difficulty ratings (numeric)}
  \item{difficulty_rank}{Relative difficulty rank (character)}
}
}
\source{
Data obtained from Kaggle: \url{https://www.kaggle.com/datasets/webdevbadger/japanese-universities}
}
\usage{
data(japan_universities_tbl_df)
}
\description{
This dataset, japan_universities_tbl_df, is a tibble containing comprehensive data about 813 universities in Japan.
It includes information such as the university name (in English and Japanese), location, type, year founded, number of faculties
and departments, availability of graduate and remote programs, and difficulty and review metrics.
The dataset preserves the original structure from its source on Kaggle.
}
\details{
The dataset name has been kept as 'japan_universities_tbl_df' to maintain consistency with the naming conventions
in the JapanAPIs package. The suffix 'tbl_df' indicates that this is a tibble data frame. The original content
has not been modified in any way.
}
