/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tlong.impl;

import cern.colt.list.tint.IntArrayList;
import cern.colt.list.tlong.LongArrayList;
import cern.colt.matrix.tlong.LongMatrix1D;
import cern.colt.matrix.tlong.LongMatrix1DProcedure;
import cern.colt.matrix.tlong.LongMatrix2D;
import cern.colt.matrix.tlong.LongMatrix2DTest;
import cern.colt.matrix.tlong.impl.DiagonalLongMatrix2D;
import cern.jet.math.tlong.LongFunctions;
import edu.emory.mathcs.utils.ConcurrencyUtils;

public class DiagonalLongMatrix2DTest
extends LongMatrix2DTest {
    protected int DLENGTH;
    protected int DINDEX;

    public DiagonalLongMatrix2DTest(String string) {
        super(string);
    }

    protected void createMatrices() throws Exception {
        this.DINDEX = 3;
        this.A = new DiagonalLongMatrix2D(this.NROWS, this.NCOLUMNS, this.DINDEX);
        this.B = new DiagonalLongMatrix2D(this.NROWS, this.NCOLUMNS, this.DINDEX);
        this.Bt = new DiagonalLongMatrix2D(this.NCOLUMNS, this.NROWS, -this.DINDEX);
        this.DLENGTH = ((DiagonalLongMatrix2D)this.A).diagonalLength();
    }

    protected void populateMatrices() {
        ConcurrencyUtils.setThreadsBeginN_2D(1);
        if (this.DINDEX >= 0) {
            int n;
            for (n = 0; n < this.DLENGTH; ++n) {
                this.A.setQuick(n, n + this.DINDEX, Math.max(1L, this.rand.nextLong() % (long)this.A.rows()));
            }
            for (n = 0; n < this.DLENGTH; ++n) {
                this.B.setQuick(n, n + this.DINDEX, Math.max(1L, this.rand.nextLong() % (long)this.A.rows()));
            }
            for (n = 0; n < this.DLENGTH; ++n) {
                this.Bt.setQuick(n - this.DINDEX, n, Math.max(1L, this.rand.nextLong() % (long)this.A.rows()));
            }
        } else {
            int n;
            for (n = 0; n < this.DLENGTH; ++n) {
                this.A.setQuick(n - this.DINDEX, n, Math.max(1L, this.rand.nextLong() % (long)this.A.rows()));
            }
            for (n = 0; n < this.DLENGTH; ++n) {
                this.B.setQuick(n - this.DINDEX, n, Math.max(1L, this.rand.nextLong() % (long)this.A.rows()));
            }
            for (n = 0; n < this.DLENGTH; ++n) {
                this.Bt.setQuick(n, n + this.DINDEX, Math.max(1L, this.rand.nextLong() % (long)this.A.rows()));
            }
        }
    }

    public void testAssignLong() {
        long l = Math.max(1L, this.rand.nextLong() % (long)this.A.rows());
        this.A.assign(l);
        if (this.DINDEX >= 0) {
            for (int i = 0; i < this.DLENGTH; ++i) {
                DiagonalLongMatrix2DTest.assertEquals((long)l, (long)this.A.getQuick(i, i + this.DINDEX));
            }
        } else {
            for (int i = 0; i < this.DLENGTH; ++i) {
                DiagonalLongMatrix2DTest.assertEquals((long)l, (long)this.A.getQuick(i - this.DINDEX, i));
            }
        }
    }

    public void testAssignLongArrayArray() {
        int n;
        long[][] lArray = new long[this.NROWS][this.NCOLUMNS];
        for (n = 0; n < this.NROWS; ++n) {
            for (int i = 0; i < this.NCOLUMNS; ++i) {
                lArray[n][i] = Math.max(1L, this.rand.nextLong() % (long)this.A.rows());
            }
        }
        this.A.assign(lArray);
        if (this.DINDEX >= 0) {
            for (n = 0; n < this.DLENGTH; ++n) {
                DiagonalLongMatrix2DTest.assertEquals((long)lArray[n][n + this.DINDEX], (long)this.A.getQuick(n, n + this.DINDEX));
            }
        } else {
            for (n = 0; n < this.DLENGTH; ++n) {
                DiagonalLongMatrix2DTest.assertEquals((long)lArray[n - this.DINDEX][n], (long)this.A.getQuick(n - this.DINDEX, n));
            }
        }
    }

    public void testAssignLongFunction() {
        LongMatrix2D longMatrix2D = this.A.copy();
        this.A.assign(LongFunctions.neg);
        if (this.DINDEX >= 0) {
            for (int i = 0; i < this.DLENGTH; ++i) {
                long l = -longMatrix2D.getQuick(i, i + this.DINDEX);
                DiagonalLongMatrix2DTest.assertEquals((long)l, (long)this.A.getQuick(i, i + this.DINDEX));
            }
        } else {
            for (int i = 0; i < this.DLENGTH; ++i) {
                long l = -longMatrix2D.getQuick(i - this.DINDEX, i);
                DiagonalLongMatrix2DTest.assertEquals((long)l, (long)this.A.getQuick(i - this.DINDEX, i));
            }
        }
    }

    public void testAssignLongMatrix2DLongLongFunction() {
        LongMatrix2D longMatrix2D = this.A.copy();
        this.A.assign(this.B, LongFunctions.div);
        if (this.DINDEX >= 0) {
            for (int i = 0; i < this.DLENGTH; ++i) {
                DiagonalLongMatrix2DTest.assertEquals((long)(longMatrix2D.getQuick(i, i + this.DINDEX) / this.B.getQuick(i, i + this.DINDEX)), (long)this.A.getQuick(i, i + this.DINDEX));
            }
        } else {
            for (int i = 0; i < this.DLENGTH; ++i) {
                DiagonalLongMatrix2DTest.assertEquals((long)(longMatrix2D.getQuick(i - this.DINDEX, i) / this.B.getQuick(i - this.DINDEX, i)), (long)this.A.getQuick(i - this.DINDEX, i));
            }
        }
    }

    public void testAssignLongMatrix2DLongLongFunctionIntArrayListIntArrayList() {
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        if (this.DINDEX >= 0) {
            for (int i = 0; i < this.DLENGTH; ++i) {
                intArrayList.add(i);
                intArrayList2.add(i + this.DINDEX);
            }
            LongMatrix2D longMatrix2D = this.A.copy();
            this.A.assign(this.B, LongFunctions.div, intArrayList, intArrayList2);
            for (int i = 0; i < this.DLENGTH; ++i) {
                DiagonalLongMatrix2DTest.assertEquals((long)(longMatrix2D.getQuick(i, i + this.DINDEX) / this.B.getQuick(i, i + this.DINDEX)), (long)this.A.getQuick(i, i + this.DINDEX));
            }
        } else {
            for (int i = 0; i < this.DLENGTH; ++i) {
                intArrayList.add(i - this.DINDEX);
                intArrayList2.add(i);
            }
            LongMatrix2D longMatrix2D = this.A.copy();
            this.A.assign(this.B, LongFunctions.div, intArrayList, intArrayList2);
            for (int i = 0; i < this.DLENGTH; ++i) {
                DiagonalLongMatrix2DTest.assertEquals((long)(longMatrix2D.getQuick(i - this.DINDEX, i) / this.B.getQuick(i - this.DINDEX, i)), (long)this.A.getQuick(i - this.DINDEX, i));
            }
        }
    }

    public void testCardinality() {
        int n = this.A.cardinality();
        DiagonalLongMatrix2DTest.assertEquals((int)this.DLENGTH, (int)n);
    }

    public void testMaxLocation() {
        this.A.assign(0L);
        if (this.DINDEX >= 0) {
            this.A.setQuick(this.NROWS / 3, this.NROWS / 3 + this.DINDEX, 7L);
            this.A.setQuick(this.NROWS / 2, this.NROWS / 2 + this.DINDEX, 1L);
            long[] lArray = this.A.getMaxLocation();
            DiagonalLongMatrix2DTest.assertEquals((long)7L, (long)lArray[0]);
            DiagonalLongMatrix2DTest.assertEquals((int)(this.NROWS / 3), (int)((int)lArray[1]));
            DiagonalLongMatrix2DTest.assertEquals((int)(this.NROWS / 3 + this.DINDEX), (int)((int)lArray[2]));
        } else {
            this.A.setQuick(this.NROWS / 3 - this.DINDEX, this.NROWS / 3, 7L);
            this.A.setQuick(this.NROWS / 2 - this.DINDEX, this.NROWS / 2, 1L);
            long[] lArray = this.A.getMaxLocation();
            DiagonalLongMatrix2DTest.assertEquals((long)7L, (long)lArray[0]);
            DiagonalLongMatrix2DTest.assertEquals((int)(this.NROWS / 3 - this.DINDEX), (int)((int)lArray[1]));
            DiagonalLongMatrix2DTest.assertEquals((int)(this.NROWS / 3), (int)((int)lArray[2]));
        }
    }

    public void testMinLocation() {
        this.A.assign(0L);
        if (this.DINDEX >= 0) {
            this.A.setQuick(this.NROWS / 3, this.NROWS / 3 + this.DINDEX, -7L);
            this.A.setQuick(this.NROWS / 2, this.NROWS / 2 + this.DINDEX, -1L);
            long[] lArray = this.A.getMinLocation();
            DiagonalLongMatrix2DTest.assertEquals((long)-7L, (long)lArray[0]);
            DiagonalLongMatrix2DTest.assertEquals((int)(this.NROWS / 3), (int)((int)lArray[1]));
            DiagonalLongMatrix2DTest.assertEquals((int)(this.NROWS / 3 + this.DINDEX), (int)((int)lArray[2]));
        } else {
            this.A.setQuick(this.NROWS / 3 - this.DINDEX, this.NROWS / 3, -7L);
            this.A.setQuick(this.NROWS / 2 - this.DINDEX, this.NROWS / 2, -1L);
            long[] lArray = this.A.getMinLocation();
            DiagonalLongMatrix2DTest.assertEquals((long)-7L, (long)lArray[0]);
            DiagonalLongMatrix2DTest.assertEquals((int)(this.NROWS / 3 - this.DINDEX), (int)((int)lArray[1]));
            DiagonalLongMatrix2DTest.assertEquals((int)(this.NROWS / 3), (int)((int)lArray[2]));
        }
    }

    public void testGetNegativeValues() {
        this.A.assign(0L);
        if (this.DINDEX >= 0) {
            this.A.setQuick(this.NROWS / 3, this.NROWS / 3 + this.DINDEX, -7L);
            this.A.setQuick(this.NROWS / 2, this.NROWS / 2 + this.DINDEX, -1L);
            IntArrayList intArrayList = new IntArrayList();
            IntArrayList intArrayList2 = new IntArrayList();
            LongArrayList longArrayList = new LongArrayList();
            this.A.getNegativeValues(intArrayList, intArrayList2, longArrayList);
            DiagonalLongMatrix2DTest.assertEquals((int)2, (int)intArrayList.size());
            DiagonalLongMatrix2DTest.assertEquals((int)2, (int)intArrayList2.size());
            DiagonalLongMatrix2DTest.assertEquals((int)2, (int)longArrayList.size());
            DiagonalLongMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.NROWS / 3));
            DiagonalLongMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.NROWS / 2));
            DiagonalLongMatrix2DTest.assertTrue((boolean)intArrayList2.contains(this.NROWS / 3 + this.DINDEX));
            DiagonalLongMatrix2DTest.assertTrue((boolean)intArrayList2.contains(this.NROWS / 2 + this.DINDEX));
            DiagonalLongMatrix2DTest.assertTrue((boolean)longArrayList.contains(-7L));
            DiagonalLongMatrix2DTest.assertTrue((boolean)longArrayList.contains(-1L));
        } else {
            this.A.setQuick(this.NROWS / 3 - this.DINDEX, this.NROWS / 3, -7L);
            this.A.setQuick(this.NROWS / 2 - this.DINDEX, this.NROWS / 2, -1L);
            IntArrayList intArrayList = new IntArrayList();
            IntArrayList intArrayList3 = new IntArrayList();
            LongArrayList longArrayList = new LongArrayList();
            this.A.getNegativeValues(intArrayList, intArrayList3, longArrayList);
            DiagonalLongMatrix2DTest.assertEquals((int)2, (int)intArrayList.size());
            DiagonalLongMatrix2DTest.assertEquals((int)2, (int)intArrayList3.size());
            DiagonalLongMatrix2DTest.assertEquals((int)2, (int)longArrayList.size());
            DiagonalLongMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.NROWS / 3 - this.DINDEX));
            DiagonalLongMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.NROWS / 2 - this.DINDEX));
            DiagonalLongMatrix2DTest.assertTrue((boolean)intArrayList3.contains(this.NROWS / 3));
            DiagonalLongMatrix2DTest.assertTrue((boolean)intArrayList3.contains(this.NROWS / 2));
            DiagonalLongMatrix2DTest.assertTrue((boolean)longArrayList.contains(-7L));
            DiagonalLongMatrix2DTest.assertTrue((boolean)longArrayList.contains(-1L));
        }
    }

    public void testGetNonZeros() {
        this.A.assign(0L);
        if (this.DINDEX >= 0) {
            this.A.setQuick(this.NROWS / 3, this.NROWS / 3 + this.DINDEX, 7L);
            this.A.setQuick(this.NROWS / 2, this.NROWS / 2 + this.DINDEX, 1L);
            IntArrayList intArrayList = new IntArrayList();
            IntArrayList intArrayList2 = new IntArrayList();
            LongArrayList longArrayList = new LongArrayList();
            this.A.getNonZeros(intArrayList, intArrayList2, longArrayList);
            DiagonalLongMatrix2DTest.assertEquals((int)2, (int)intArrayList.size());
            DiagonalLongMatrix2DTest.assertEquals((int)2, (int)intArrayList2.size());
            DiagonalLongMatrix2DTest.assertEquals((int)2, (int)longArrayList.size());
            DiagonalLongMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.NROWS / 3));
            DiagonalLongMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.NROWS / 2));
            DiagonalLongMatrix2DTest.assertTrue((boolean)intArrayList2.contains(this.NROWS / 3 + this.DINDEX));
            DiagonalLongMatrix2DTest.assertTrue((boolean)intArrayList2.contains(this.NROWS / 2 + this.DINDEX));
            DiagonalLongMatrix2DTest.assertTrue((boolean)longArrayList.contains(7L));
            DiagonalLongMatrix2DTest.assertTrue((boolean)longArrayList.contains(1L));
        } else {
            this.A.setQuick(this.NROWS / 3 - this.DINDEX, this.NROWS / 3, 7L);
            this.A.setQuick(this.NROWS / 2 - this.DINDEX, this.NROWS / 2, 1L);
            IntArrayList intArrayList = new IntArrayList();
            IntArrayList intArrayList3 = new IntArrayList();
            LongArrayList longArrayList = new LongArrayList();
            this.A.getNonZeros(intArrayList, intArrayList3, longArrayList);
            DiagonalLongMatrix2DTest.assertEquals((int)2, (int)intArrayList.size());
            DiagonalLongMatrix2DTest.assertEquals((int)2, (int)intArrayList3.size());
            DiagonalLongMatrix2DTest.assertEquals((int)2, (int)longArrayList.size());
            DiagonalLongMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.NROWS / 3 - this.DINDEX));
            DiagonalLongMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.NROWS / 2 - this.DINDEX));
            DiagonalLongMatrix2DTest.assertTrue((boolean)intArrayList3.contains(this.NROWS / 3));
            DiagonalLongMatrix2DTest.assertTrue((boolean)intArrayList3.contains(this.NROWS / 2));
            DiagonalLongMatrix2DTest.assertTrue((boolean)longArrayList.contains(7L));
            DiagonalLongMatrix2DTest.assertTrue((boolean)longArrayList.contains(1L));
        }
    }

    public void testGetPositiveValues() {
        this.A.assign(0L);
        if (this.DINDEX >= 0) {
            this.A.setQuick(this.NROWS / 3, this.NROWS / 3 + this.DINDEX, 7L);
            this.A.setQuick(this.NROWS / 2, this.NROWS / 2 + this.DINDEX, 1L);
            IntArrayList intArrayList = new IntArrayList();
            IntArrayList intArrayList2 = new IntArrayList();
            LongArrayList longArrayList = new LongArrayList();
            this.A.getPositiveValues(intArrayList, intArrayList2, longArrayList);
            DiagonalLongMatrix2DTest.assertEquals((int)2, (int)intArrayList.size());
            DiagonalLongMatrix2DTest.assertEquals((int)2, (int)intArrayList2.size());
            DiagonalLongMatrix2DTest.assertEquals((int)2, (int)longArrayList.size());
            DiagonalLongMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.NROWS / 3));
            DiagonalLongMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.NROWS / 2));
            DiagonalLongMatrix2DTest.assertTrue((boolean)intArrayList2.contains(this.NROWS / 3 + this.DINDEX));
            DiagonalLongMatrix2DTest.assertTrue((boolean)intArrayList2.contains(this.NROWS / 2 + this.DINDEX));
            DiagonalLongMatrix2DTest.assertTrue((boolean)longArrayList.contains(7L));
            DiagonalLongMatrix2DTest.assertTrue((boolean)longArrayList.contains(1L));
        } else {
            this.A.setQuick(this.NROWS / 3 - this.DINDEX, this.NROWS / 3, 7L);
            this.A.setQuick(this.NROWS / 2 - this.DINDEX, this.NROWS / 2, 1L);
            IntArrayList intArrayList = new IntArrayList();
            IntArrayList intArrayList3 = new IntArrayList();
            LongArrayList longArrayList = new LongArrayList();
            this.A.getPositiveValues(intArrayList, intArrayList3, longArrayList);
            DiagonalLongMatrix2DTest.assertEquals((int)2, (int)intArrayList.size());
            DiagonalLongMatrix2DTest.assertEquals((int)2, (int)intArrayList3.size());
            DiagonalLongMatrix2DTest.assertEquals((int)2, (int)longArrayList.size());
            DiagonalLongMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.NROWS / 3 - this.DINDEX));
            DiagonalLongMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.NROWS / 2 - this.DINDEX));
            DiagonalLongMatrix2DTest.assertTrue((boolean)intArrayList3.contains(this.NROWS / 3));
            DiagonalLongMatrix2DTest.assertTrue((boolean)intArrayList3.contains(this.NROWS / 2));
            DiagonalLongMatrix2DTest.assertTrue((boolean)longArrayList.contains(7L));
            DiagonalLongMatrix2DTest.assertTrue((boolean)longArrayList.contains(1L));
        }
    }

    public void testToArray() {
        long[][] lArray = this.A.toArray();
        DiagonalLongMatrix2DTest.assertTrue((this.NROWS == lArray.length ? 1 : 0) != 0);
        for (int i = 0; i < this.NROWS; ++i) {
            DiagonalLongMatrix2DTest.assertTrue((this.NCOLUMNS == lArray[i].length ? 1 : 0) != 0);
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                DiagonalLongMatrix2DTest.assertEquals((long)lArray[i][j], (long)this.A.getQuick(i, j));
            }
        }
    }

    public void testVectorize() {
        LongMatrix1D longMatrix1D = this.A.vectorize();
        int n = 0;
        for (int i = 0; i < this.NCOLUMNS; ++i) {
            for (int j = 0; j < this.NROWS; ++j) {
                DiagonalLongMatrix2DTest.assertEquals((long)this.A.getQuick(j, i), (long)longMatrix1D.getQuick(n++));
            }
        }
    }

    public void testViewColumn() {
        LongMatrix1D longMatrix1D = this.A.viewColumn(this.NCOLUMNS / 2);
        DiagonalLongMatrix2DTest.assertEquals((long)this.NROWS, (long)longMatrix1D.size());
        for (int i = 0; i < this.NROWS; ++i) {
            DiagonalLongMatrix2DTest.assertEquals((long)this.A.getQuick(i, this.NCOLUMNS / 2), (long)longMatrix1D.getQuick(i));
        }
    }

    public void testViewColumnFlip() {
        LongMatrix2D longMatrix2D = this.A.viewColumnFlip();
        DiagonalLongMatrix2DTest.assertEquals((long)this.A.size(), (long)longMatrix2D.size());
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                DiagonalLongMatrix2DTest.assertEquals((long)this.A.getQuick(i, this.NCOLUMNS - 1 - j), (long)longMatrix2D.getQuick(i, j));
            }
        }
    }

    public void testViewDice() {
        LongMatrix2D longMatrix2D = this.A.viewDice();
        DiagonalLongMatrix2DTest.assertEquals((int)this.NROWS, (int)longMatrix2D.columns());
        DiagonalLongMatrix2DTest.assertEquals((int)this.NCOLUMNS, (int)longMatrix2D.rows());
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                DiagonalLongMatrix2DTest.assertEquals((long)this.A.getQuick(i, j), (long)longMatrix2D.getQuick(j, i));
            }
        }
    }

    public void testViewPart() {
        LongMatrix2D longMatrix2D = this.A.viewPart(this.NROWS / 2, this.NCOLUMNS / 2, this.NROWS / 3, this.NCOLUMNS / 3);
        DiagonalLongMatrix2DTest.assertEquals((int)(this.NROWS / 3), (int)longMatrix2D.rows());
        DiagonalLongMatrix2DTest.assertEquals((int)(this.NCOLUMNS / 3), (int)longMatrix2D.columns());
        for (int i = 0; i < this.NROWS / 3; ++i) {
            for (int j = 0; j < this.NCOLUMNS / 3; ++j) {
                DiagonalLongMatrix2DTest.assertEquals((long)this.A.getQuick(this.NROWS / 2 + i, this.NCOLUMNS / 2 + j), (long)longMatrix2D.getQuick(i, j));
            }
        }
    }

    public void testViewRow() {
        LongMatrix1D longMatrix1D = this.A.viewRow(this.NROWS / 2);
        DiagonalLongMatrix2DTest.assertEquals((long)this.NCOLUMNS, (long)longMatrix1D.size());
        for (int i = 0; i < this.NCOLUMNS; ++i) {
            DiagonalLongMatrix2DTest.assertEquals((long)this.A.getQuick(this.NROWS / 2, i), (long)longMatrix1D.getQuick(i));
        }
    }

    public void testViewRowFlip() {
        LongMatrix2D longMatrix2D = this.A.viewRowFlip();
        DiagonalLongMatrix2DTest.assertEquals((long)this.A.size(), (long)longMatrix2D.size());
        for (int i = 0; i < this.NROWS; ++i) {
            for (int j = 0; j < this.NCOLUMNS; ++j) {
                DiagonalLongMatrix2DTest.assertEquals((long)this.A.getQuick(this.NROWS - 1 - i, j), (long)longMatrix2D.getQuick(i, j));
            }
        }
    }

    public void testViewSelectionLongMatrix1DProcedure() {
        this.A.assign(0L);
        if (this.DINDEX >= 0) {
            this.A.setQuick(this.NROWS / 4, this.NROWS / 4 + this.DINDEX, 2L);
            this.A.setQuick(this.NROWS / 2, this.NROWS / 2 + this.DINDEX, 2L);
            LongMatrix2D longMatrix2D = this.A.viewSelection(new LongMatrix1DProcedure(){

                public boolean apply(LongMatrix1D longMatrix1D) {
                    return longMatrix1D.getQuick(DiagonalLongMatrix2DTest.this.NROWS / 4 + DiagonalLongMatrix2DTest.this.DINDEX) == 2L;
                }
            });
            DiagonalLongMatrix2DTest.assertEquals((int)1, (int)longMatrix2D.rows());
            DiagonalLongMatrix2DTest.assertEquals((int)this.NCOLUMNS, (int)longMatrix2D.columns());
            DiagonalLongMatrix2DTest.assertEquals((long)this.A.getQuick(this.NROWS / 4, this.NROWS / 4 + this.DINDEX), (long)longMatrix2D.getQuick(0, this.NROWS / 4 + this.DINDEX));
        } else {
            this.A.setQuick(this.NROWS / 4 - this.DINDEX, this.NROWS / 4, 2L);
            this.A.setQuick(this.NROWS / 2 - this.DINDEX, this.NROWS / 2, 2L);
            LongMatrix2D longMatrix2D = this.A.viewSelection(new LongMatrix1DProcedure(){

                public boolean apply(LongMatrix1D longMatrix1D) {
                    return longMatrix1D.getQuick(DiagonalLongMatrix2DTest.this.NROWS / 4) == 2L;
                }
            });
            DiagonalLongMatrix2DTest.assertEquals((int)1, (int)longMatrix2D.rows());
            DiagonalLongMatrix2DTest.assertEquals((int)this.NCOLUMNS, (int)longMatrix2D.columns());
            DiagonalLongMatrix2DTest.assertEquals((long)this.A.getQuick(this.NROWS / 4 - this.DINDEX, this.NROWS / 4), (long)longMatrix2D.getQuick(0, this.NROWS / 4));
        }
    }

    public void testViewSelectionIntArrayIntArray() {
        int[] nArray = new int[]{this.NROWS / 6, this.NROWS / 5, this.NROWS / 4, this.NROWS / 3, this.NROWS / 2};
        int[] nArray2 = new int[]{this.NROWS / 6, this.NROWS / 5, this.NROWS / 4, this.NROWS / 3, this.NROWS / 2, this.NROWS - 1};
        LongMatrix2D longMatrix2D = this.A.viewSelection(nArray, nArray2);
        DiagonalLongMatrix2DTest.assertEquals((int)nArray.length, (int)longMatrix2D.rows());
        DiagonalLongMatrix2DTest.assertEquals((int)nArray2.length, (int)longMatrix2D.columns());
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray2.length; ++j) {
                DiagonalLongMatrix2DTest.assertEquals((long)this.A.getQuick(nArray[i], nArray2[j]), (long)longMatrix2D.getQuick(i, j));
            }
        }
    }

    public void testViewSorted() {
        LongMatrix2D longMatrix2D = this.A.viewSorted(1);
        for (int i = 0; i < this.NROWS - 1; ++i) {
            DiagonalLongMatrix2DTest.assertTrue((longMatrix2D.getQuick(i + 1, 1) >= longMatrix2D.getQuick(i, 1) ? 1 : 0) != 0);
        }
    }

    public void testViewStrides() {
        int n = 3;
        int n2 = 5;
        LongMatrix2D longMatrix2D = this.A.viewStrides(n, n2);
        for (int i = 0; i < longMatrix2D.rows(); ++i) {
            for (int j = 0; j < longMatrix2D.columns(); ++j) {
                DiagonalLongMatrix2DTest.assertEquals((long)this.A.getQuick(i * n, j * n2), (long)longMatrix2D.getQuick(i, j));
            }
        }
    }

    public void testZMultLongMatrix2DLongMatrix2DLongLongBooleanBoolean() {
        int n;
        long l;
        int n2;
        int n3;
        long l2 = 3L;
        long l3 = 5L;
        LongMatrix2D longMatrix2D = new DiagonalLongMatrix2D(this.NROWS, this.NROWS, 0);
        for (int i = 0; i < this.DLENGTH; ++i) {
            longMatrix2D.setQuick(i, i, Math.max(1L, this.rand.nextLong() % (long)this.A.rows()));
        }
        long[][] lArray = longMatrix2D.toArray();
        longMatrix2D = this.A.zMult(this.Bt, longMatrix2D, l2, l3, false, false);
        for (n3 = 0; n3 < this.NROWS; ++n3) {
            for (n2 = 0; n2 < this.NROWS; ++n2) {
                l = 0L;
                for (n = 0; n < this.NCOLUMNS; ++n) {
                    l += this.A.getQuick(n2, n) * this.Bt.getQuick(n, n3);
                }
                lArray[n2][n3] = l * l2 + lArray[n2][n3] * l3;
            }
        }
        for (n3 = 0; n3 < this.NROWS; ++n3) {
            for (n2 = 0; n2 < this.NROWS; ++n2) {
                DiagonalLongMatrix2DTest.assertEquals((long)lArray[n3][n2], (long)longMatrix2D.getQuick(n3, n2));
            }
        }
        longMatrix2D = null;
        longMatrix2D = this.A.zMult(this.Bt, longMatrix2D, l2, l3, false, false);
        lArray = new long[this.NROWS][this.NROWS];
        for (n3 = 0; n3 < this.NROWS; ++n3) {
            for (n2 = 0; n2 < this.NROWS; ++n2) {
                l = 0L;
                for (n = 0; n < this.NCOLUMNS; ++n) {
                    l += this.A.getQuick(n2, n) * this.Bt.getQuick(n, n3);
                }
                lArray[n2][n3] = l * l2;
            }
        }
        for (n3 = 0; n3 < this.NROWS; ++n3) {
            for (n2 = 0; n2 < this.NROWS; ++n2) {
                DiagonalLongMatrix2DTest.assertEquals((long)lArray[n3][n2], (long)longMatrix2D.getQuick(n3, n2));
            }
        }
        longMatrix2D = new DiagonalLongMatrix2D(this.NCOLUMNS, this.NCOLUMNS, 0);
        for (n3 = 0; n3 < this.DLENGTH; ++n3) {
            longMatrix2D.setQuick(n3, n3, Math.max(1L, this.rand.nextLong() % (long)this.A.rows()));
        }
        lArray = longMatrix2D.toArray();
        longMatrix2D = this.A.zMult(this.B, longMatrix2D, l2, l3, true, false);
        for (n3 = 0; n3 < this.NCOLUMNS; ++n3) {
            for (n2 = 0; n2 < this.NCOLUMNS; ++n2) {
                l = 0L;
                for (n = 0; n < this.NROWS; ++n) {
                    l += this.A.getQuick(n, n2) * this.B.getQuick(n, n3);
                }
                lArray[n2][n3] = l * l2 + lArray[n2][n3] * l3;
            }
        }
        for (n3 = 0; n3 < this.NCOLUMNS; ++n3) {
            for (n2 = 0; n2 < this.NCOLUMNS; ++n2) {
                DiagonalLongMatrix2DTest.assertEquals((long)lArray[n3][n2], (long)longMatrix2D.getQuick(n3, n2));
            }
        }
        longMatrix2D = null;
        longMatrix2D = this.A.zMult(this.B, longMatrix2D, l2, l3, true, false);
        lArray = new long[this.NCOLUMNS][this.NCOLUMNS];
        for (n3 = 0; n3 < this.NCOLUMNS; ++n3) {
            for (n2 = 0; n2 < this.NCOLUMNS; ++n2) {
                l = 0L;
                for (n = 0; n < this.NROWS; ++n) {
                    l += this.A.getQuick(n, n2) * this.B.getQuick(n, n3);
                }
                lArray[n2][n3] = l * l2;
            }
        }
        for (n3 = 0; n3 < this.NCOLUMNS; ++n3) {
            for (n2 = 0; n2 < this.NCOLUMNS; ++n2) {
                DiagonalLongMatrix2DTest.assertEquals((long)lArray[n3][n2], (long)longMatrix2D.getQuick(n3, n2));
            }
        }
        longMatrix2D = new DiagonalLongMatrix2D(this.NROWS, this.NROWS, 0);
        for (n3 = 0; n3 < this.DLENGTH; ++n3) {
            longMatrix2D.setQuick(n3, n3, Math.max(1L, this.rand.nextLong() % (long)this.A.rows()));
        }
        lArray = longMatrix2D.toArray();
        longMatrix2D = this.A.zMult(this.B, longMatrix2D, l2, l3, false, true);
        for (n3 = 0; n3 < this.NROWS; ++n3) {
            for (n2 = 0; n2 < this.NROWS; ++n2) {
                l = 0L;
                for (n = 0; n < this.NCOLUMNS; ++n) {
                    l += this.A.getQuick(n2, n) * this.B.getQuick(n3, n);
                }
                lArray[n2][n3] = l * l2 + lArray[n2][n3] * l3;
            }
        }
        for (n3 = 0; n3 < this.NROWS; ++n3) {
            for (n2 = 0; n2 < this.NROWS; ++n2) {
                DiagonalLongMatrix2DTest.assertEquals((long)lArray[n3][n2], (long)longMatrix2D.getQuick(n3, n2));
            }
        }
        longMatrix2D = null;
        longMatrix2D = this.A.zMult(this.B, longMatrix2D, l2, l3, false, true);
        lArray = new long[this.NROWS][this.NROWS];
        for (n3 = 0; n3 < this.NROWS; ++n3) {
            for (n2 = 0; n2 < this.NROWS; ++n2) {
                l = 0L;
                for (n = 0; n < this.NCOLUMNS; ++n) {
                    l += this.A.getQuick(n2, n) * this.B.getQuick(n3, n);
                }
                lArray[n2][n3] = l * l2;
            }
        }
        for (n3 = 0; n3 < this.NROWS; ++n3) {
            for (n2 = 0; n2 < this.NROWS; ++n2) {
                DiagonalLongMatrix2DTest.assertEquals((long)lArray[n3][n2], (long)longMatrix2D.getQuick(n3, n2));
            }
        }
        longMatrix2D = new DiagonalLongMatrix2D(this.NCOLUMNS, this.NCOLUMNS, 0);
        for (n3 = 0; n3 < this.DLENGTH; ++n3) {
            longMatrix2D.setQuick(n3, n3, Math.max(1L, this.rand.nextLong() % (long)this.A.rows()));
        }
        lArray = longMatrix2D.toArray();
        longMatrix2D = this.A.zMult(this.Bt, longMatrix2D, l2, l3, true, true);
        for (n3 = 0; n3 < this.NCOLUMNS; ++n3) {
            for (n2 = 0; n2 < this.NCOLUMNS; ++n2) {
                l = 0L;
                for (n = 0; n < this.NROWS; ++n) {
                    l += this.A.getQuick(n, n2) * this.Bt.getQuick(n3, n);
                }
                lArray[n2][n3] = l * l2 + lArray[n2][n3] * l3;
            }
        }
        for (n3 = 0; n3 < this.NCOLUMNS; ++n3) {
            for (n2 = 0; n2 < this.NCOLUMNS; ++n2) {
                DiagonalLongMatrix2DTest.assertEquals((long)lArray[n3][n2], (long)longMatrix2D.getQuick(n3, n2));
            }
        }
        longMatrix2D = null;
        longMatrix2D = this.A.zMult(this.Bt, longMatrix2D, l2, l3, true, true);
        lArray = new long[this.NCOLUMNS][this.NCOLUMNS];
        for (n3 = 0; n3 < this.NCOLUMNS; ++n3) {
            for (n2 = 0; n2 < this.NCOLUMNS; ++n2) {
                l = 0L;
                for (n = 0; n < this.NROWS; ++n) {
                    l += this.A.getQuick(n, n2) * this.Bt.getQuick(n3, n);
                }
                lArray[n2][n3] = l * l2;
            }
        }
        for (n3 = 0; n3 < this.NCOLUMNS; ++n3) {
            for (n2 = 0; n2 < this.NCOLUMNS; ++n2) {
                DiagonalLongMatrix2DTest.assertEquals((long)lArray[n3][n2], (long)longMatrix2D.getQuick(n3, n2));
            }
        }
    }
}

