/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo.solver;

import cern.colt.matrix.Norm;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.algo.DenseDoubleAlgebra;
import cern.colt.matrix.tdouble.algo.solver.DoubleIterationMonitor;
import cern.colt.matrix.tdouble.algo.solver.DoubleIterationReporter;
import cern.colt.matrix.tdouble.algo.solver.IterativeSolverDoubleNotConvergedException;
import cern.colt.matrix.tdouble.algo.solver.NoDoubleIterationReporter;

public abstract class AbstractDoubleIterationMonitor
implements DoubleIterationMonitor {
    protected int iter;
    protected Norm normType = Norm.Two;
    protected DoubleIterationReporter reporter = new NoDoubleIterationReporter();
    protected double residual;

    public void setFirst() {
        this.iter = 0;
    }

    public boolean isFirst() {
        return this.iter == 0;
    }

    public void next() {
        ++this.iter;
    }

    public int iterations() {
        return this.iter;
    }

    public boolean converged(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) throws IterativeSolverDoubleNotConvergedException {
        return this.converged(DenseDoubleAlgebra.DEFAULT.norm(doubleMatrix1D, this.normType), doubleMatrix1D2);
    }

    public boolean converged(double d, DoubleMatrix1D doubleMatrix1D) throws IterativeSolverDoubleNotConvergedException {
        this.reporter.monitor(d, doubleMatrix1D, this.iter);
        this.residual = d;
        return this.convergedI(d, doubleMatrix1D);
    }

    public boolean converged(double d) throws IterativeSolverDoubleNotConvergedException {
        this.reporter.monitor(d, this.iter);
        this.residual = d;
        return this.convergedI(d);
    }

    protected abstract boolean convergedI(double var1, DoubleMatrix1D var3) throws IterativeSolverDoubleNotConvergedException;

    protected abstract boolean convergedI(double var1) throws IterativeSolverDoubleNotConvergedException;

    public boolean converged(DoubleMatrix1D doubleMatrix1D) throws IterativeSolverDoubleNotConvergedException {
        return this.converged(DenseDoubleAlgebra.DEFAULT.norm(doubleMatrix1D, this.normType));
    }

    public Norm getNormType() {
        return this.normType;
    }

    public void setNormType(Norm norm) {
        this.normType = norm;
    }

    public DoubleIterationReporter getIterationReporter() {
        return this.reporter;
    }

    public void setIterationReporter(DoubleIterationReporter doubleIterationReporter) {
        this.reporter = doubleIterationReporter;
    }

    public double residual() {
        return this.residual;
    }
}

