% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intlen.R
\name{intlen}
\alias{intlen}
\title{Preferred Interval Length for Regularizing Irregular Longitudinal Data}
\usage{
intlen(data, subject_col, time_col)
}
\arguments{
\item{data}{A data frame containing the irregular longitudinal data.}

\item{subject_col}{The column name for unique subject IDs.}

\item{time_col}{The column name for time points.}
}
\value{
Computed preferred interval length.
}
\description{
This function calculates the optimal interval length for regularizing
irregular longitudinal data based on the given subject ID and time columns.
}
\details{
The function calculates the optimal interval length based on the observed range of time points and the average number of measurements per subject.
}
\examples{
sdata <- sdata[1:100,]
intlen(sdata, "subject_id", "time")

}
