% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IDEAFilter_item.R
\name{IDEAFilter_item}
\alias{IDEAFilter_item}
\title{The server function for the IDEA filter item module}
\usage{
IDEAFilter_item(
  id,
  data,
  column_name = NULL,
  filters = list(),
  ...,
  col_subset = NULL,
  preselection = NULL,
  verbose = FALSE
)
}
\arguments{
\item{id}{a module id name}

\item{data}{a \code{reactive expression} returning a \code{data.frame} to use
as the input to the filter item module}

\item{column_name}{a value indicating the name of the column to be filtered}

\item{filters}{a \code{reactive expression} containing the a list of filters
passed as \code{language} types}

\item{...}{placeholder for inclusion of additional parameters in future development}

\item{col_subset}{a \code{vector} containing the list of allowable columns to filter on}

\item{preselection}{a \code{list} that can be used to pre-populate the filter}

\item{verbose}{a \code{logical} value indicating whether or not to print log
statements out to the console}
}
\value{
a \code{\link[shiny]{reactiveValues}} list of four reactive elements;
  (1) the code to filter a vector with the name of the specified data column,
  (2) a flag indicating when to remove this filter, (3) the append list of
  combining the `filters` argument with (1), and (4) the column name of the
  `data` used to create the item.
}
\description{
Serves as a wrapper for \code{\link{shiny_data_filter_item}} and utilizes
\code{moduleSever()} for a more modern implementation of the data item
filter.
}
\keyword{internal}
