% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HiGarrote.R
\name{nnGarrote}
\alias{nnGarrote}
\title{Nonnegative Garrote Method with Hierarchical Structures}
\usage{
nnGarrote(X, y, heredity = "weak", model_type = 1)
}
\arguments{
\item{X}{An \eqn{n \times p} input matrix, where \eqn{n} is the number of data and \eqn{p} is the number of variables.}

\item{y}{A vector for the responses.}

\item{heredity}{Specifies the heredity principles to be used. Supported options are \code{"weak"} and \code{"strong"}. The default is \code{"weak"}.}

\item{model_type}{Integer indicating the type of model to construct.
\describe{
\item{model_type = 1}{The model matrix includes linear effects, two-factor interactions, and quadratic effects.}
\item{model_type = 2}{The model matrix includes linear effects and two-factor interactions.}
}
The default is \code{model_type = 1}.}
}
\value{
The function returns a list with:
\describe{
\item{\code{nng_estimate}}{A vector for the nonnegative garrote estimates of the identified variables.}
\item{\code{U}}{A scaled model matrix.}
\item{\code{pred_info}}{A list of information required for further prediction.}
}
}
\description{
`nnGarrote()` implements the nonnegative garrote method, as described in Yuan et al. (2009), for selecting important variables while preserving hierarchical structures.
The method begins by obtaining the least squares estimates of the regression parameters under a linear model.
These initial estimates are then used in the nonnegative garrote to perform variable selection.
Note that this method is suitable only when the number of observations is much larger than the number of variables, ensuring that the least squares estimation remains reliable.
}
\examples{
# Generate data
x1 <- runif(100)
x2 <- runif(100)
x3 <- runif(100)
error <- rnorm(100)
X <- data.frame(x1, x2, x3)
U <- model.matrix(~. + x1:x2 + x1:x3 + x2:x3 + I(x1^2) + I(x2^2) + I(x3^2) - 1, X)
U <- data.frame(scale(U))
colnames(U) <- c("x1", "x2", "x3", "x1:x1", "x2:x2", "x3:x3", "x1:x2", "x1:x3", "x2:x3")
y <- 3 + 3*U$x1 + 3*U$`x1:x1` + 3*U$`x1:x2`+ 3*U$`x1:x3` + error

# Fit nnGarrote
fit_nng <- HiGarrote::nnGarrote(X, y)
fit_nng$nng_estimate

}
\references{
Yuan, M., Joseph, V. R., and Zou H. (2009). Structured Variable Selection and Estimation. 
\emph{The Annals of Applied Statistics}, 3(4), 1738–1757. \doi{10.1214/09-AOAS254}.
}
