% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/define_haplotypes_globally.R
\name{define_haplotypes_globally}
\alias{define_haplotypes_globally}
\title{Define Haplotypes Globally}
\usage{
define_haplotypes_globally(
  vcf_list,
  LD_list,
  epsilon = NULL,
  MGmin = 30,
  hetmiss_as = "allele",
  keep_outliers = FALSE
)
}
\arguments{
\item{vcf_list}{A list of VCF files.}

\item{LD_list}{A list LD matrix files.}

\item{epsilon}{A list of epsilon values the same length as the list of VCF files. The epsilon affects haplotype size. It is a parameter of the DBSCAN clustering tool. The default is 0.6.}

\item{MGmin}{The minimum number of SNPs within a cluster for it to be defined as a haplotype.The default is 30.}

\item{hetmiss_as}{Affects how missing data is handled for all instances where one allele in a genotype is missing.If hetmiss_as = "allele" the genotype is assumed to be heterozygous. If hetmiss_as = "miss" the genotype is treated as NA.}

\item{keep_outliers}{If FALSE, removes SNPs that are determined to be outliers.}
}
\value{
A collated list of haplotype tables for all VCF files provided.
}
\description{
This function requires a list of VCF files and an LD matrices. The list of VCF files and LD matrices must be the same length.
It will then define local haplotypes for each pair of files (VCF and LD matrix) and return a list of tables.
Each table within the list represents one haplotype.
These haplotype tables display the SNP genotypes within the haplotype.
}
