% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distinctColorPalette.R
\name{distinctColorPalette}
\alias{distinctColorPalette}
\title{Generate optimally distinct color palettes}
\usage{
distinctColorPalette(count = 1, seed = NULL, darken = 0)
}
\arguments{
\item{count}{Integer, number of colors (>= 1). May be ineffective for count > 40.}

\item{seed}{Integer, seed number to produce repeatable palettes.}

\item{darken}{Numeric specifying the amount of darkening applied to the color palette. See \link[colorspace:lighten]{colorspace::darken}.
Negative values will lighten the palette.}
}
\value{
\code{distinctColorPalette} returns a character vector of \code{count} optimally distinct colors in hexadecimal codes.
}
\description{
\code{distinctColorPalette} generates an attractive palette of random colors.
}
\details{
Adapted from the randomcoloR package \url{https://cran.r-project.org/package=randomcoloR}.
}
\examples{
distinctColorPalette()
}
