% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functioncollection_export.R
\name{WriteGeoData}
\alias{WriteGeoData}
\title{Write a 'GeoData.txt' file}
\usage{
WriteGeoData(x, filename, digits = 6)
}
\arguments{
\item{x}{The object to be written, a dataframe, as an object returned from \code{\link{ReadGeoData}}.
\code{NA}s in any column will result in a warning (no \code{NA}s allowed in GeoData data columns).}

\item{filename}{A character string naming a file to write to. Windows users: Note that
Paths are separated by '/', not '\\'.}

\item{digits}{Integer, number of significant digits \strong{in SLC class columns} to export. See \code{\link{signif}}.}
}
\value{
No return value, called for export to text files.
}
\description{
This is a convenience wrapper function to export a 'GeoData.txt' file from R.
}
\details{
\code{WriteGeoData} exports a GeoData dataframe using \code{\link[data.table]{fwrite}}. \code{SUBID} and \code{MAINDOWN}
columns are forced to non-scientific notation by conversion to text strings prior to exporting. For all other numeric columns,
use \code{\link[data.table]{fwrite}} argument \code{scipen}.
HYPE does neither allow empty values in any GeoData column nor any string elements with more than 50 characters. The
function will return with warnings if \code{NA}s or long strings were exported.
}
\examples{
te <- ReadGeoData(filename = system.file("demo_model", "GeoData.txt", package = "HYPEtools"))
summary(te)
WriteGeoData(x = te, filename = tempfile())

}
