% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_SumSLCClasses.R
\name{SumSLCClasses}
\alias{SumSLCClasses}
\title{Calculate sums of SLC classes in a GeoData file}
\usage{
SumSLCClasses(gd, plot.box = TRUE, silent = FALSE, ...)
}
\arguments{
\item{gd}{Data frame containing columns with SLC fractions, typically a 'GeoData.txt' file imported with \code{\link{ReadGeoData}}.}

\item{plot.box}{Logical, if \code{TRUE}, a box plot of SLC area sums is returned.}

\item{silent}{Logical, if set to \code{TRUE}, the default printing of a result summary is suppressed.}

\item{...}{Other arguments to be passed to \code{\link{boxplot}}.}
}
\value{
\code{SumSLCClasses} returns a vector of SLC sums, invisibly if \code{plot.box} is \code{TRUE}.
}
\description{
\code{SumSLCClasses} sums all SLC classes for each SUBID in a GeoData data frame and optionally plots the results.
}
\details{
\code{SumSLCClasses} is a wrapper for \code{\link{colSums}} with a boxplot output option, and allows to quickly control if SLCs of all SUBIDs in a
GeoData data frame sum up to 1.
}
\examples{
te <- ReadGeoData(filename = system.file("demo_model", "GeoData.txt", package = "HYPEtools"))
SumSLCClasses(gd = te, plot.box = TRUE)
SumSLCClasses(gd = te, plot.box = FALSE)


}
