% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessoryFunctions.R
\name{multiQueryRelease}
\alias{multiQueryRelease}
\title{Search Multiple Elements of Allele Names Across Release Versions}
\usage{
multiQueryRelease(rel, variants = "", all = TRUE)
}
\arguments{
\item{rel}{An IPD-IMGT/HLA Database release version, represented as either a character (e.g., "3.58.0") or a numeric (e.g., 3580) value.}

\item{variants}{A vector of character strings. The values in 'variants' can be any part of a locus or allele name (e.g., "DR", "02:01", "DRB1*08:07"). The default ("") specifies all alleles in 'rel'.}

\item{all}{A logical. When 'all' = TRUE, a vector of all alleles in 'rel' that share all elements of 'variants' is returned.  When 'all' = FALSE, the number of alleles that share all elements of 'variants' in 'rel' is returned.}
}
\value{
A character vector of all alleles that share all 'variants' in 'rel' or the number of alleles that share all 'variants' in 'rel'.
}
\description{
Searches specific release versions in the AlleleListHistory object for a set of user-defined allele-name elements.
}
\examples{
# Identify DRB1 allele names that include a 'Q' character in release 3.58.0.
multiQueryRelease("3.58.0",c("DRB1","Q"),TRUE) 
# Identify the number of null (N) DRB1 alleles.
multiQueryRelease("3.58.0",c("DRB1","N"),FALSE)

}
