% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildAlignments.R
\name{buildAlignments}
\alias{buildAlignments}
\title{Build Amino Acid, cDNA and gDNA Alignments}
\usage{
buildAlignments(loci, source, version = "Latest")
}
\arguments{
\item{loci}{A character vector of HLA gene names (e.g., "DRB1", c("A","C")).}

\item{source}{A character vector of alignment types. The allowed values are "AA", "cDNA", and "gDNA". If 'source' is "cDNA", both codon and cDNA nucleotide alignments are generated. If source is 'AA' or 'gDNA', a single peptide or genomic nucleotide alignment is generated. Up to four alignments will be returned for a locus, as determined by its ability to be transcribed or translated.}

\item{version}{A character string describing the desired release version (branch) of the ANHIG/IMGTHLA Github repository (e.g. '3.53.0'). The default value ('Latest') returns alignments for the most recent release.}
}
\value{
A list object with a data frame of all allele names (and trimmed, two-field allele names) and their corresponding sequences (Amino Acid, codon, cDNA, or gDNA) for a specific locus, as well as version details for the returned information. These alignments identify locations of feature boundaries in relation to amino acid, codon, cDNA, and gDNA sequences. When a three- or four-field allele name includes an expression variant suffix, that suffix is appended to the trimmed name.
}
\description{
Returns a list of data frames of amino acid, codon, nucleotide and genomic alignments, with version information.
}
\note{
For internal HLAtools use.
}
