% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GLupdater.R
\name{GLupdate}
\alias{GLupdate}
\title{Update a GL String Code to a Specified IPD-IMGT/HLA Database Version}
\usage{
GLupdate(GLSC, to, expand = FALSE, verbose = FALSE)
}
\arguments{
\item{GLSC}{A GL String Code containing HLA allele names.}

\item{to}{A character string identifying the IPD-IMGT/HLA Database release version to translate 'GLSC' to. Values can range from version 1.05.0 to the loaded version of the alleleListHistory object.}

\item{expand}{A logical that indicates if the lowest-numbered truncated allele names that match truncated allele names in 'GLSC' should be returned (expand = FALSE), or if a slash-delimited string of all matching full-length allele names should be returned (expand = TRUE). The default value is FALSE.}

\item{verbose}{A logical that indicates if messages regarding the update process should be sent to the console (TRUE) or not (FALSE). The default value is FALSE.}
}
\value{
A GL String Code updated to the 'to' release version.
}
\description{
Updates the elements of a GLString Code across IPD-IMGT/HLA Database release versions. Truncated allele names can be expanded to the list of all allele names that contain the truncated name.
}
\note{
This function is maintained for compatibility with previous releases, and will be removed in a future release. HLAtools users are advised to use updateGL().
}
\examples{
GLupdate(GLSC.ex$GL.String.Code[1],"2.15.0",FALSE,FALSE)
GLupdate(GLSC.ex$GL.String.Code[1],"2.15.0",TRUE,FALSE)

}
\references{
Mack et al. HLA 2023;102(2):206-212 https://doi.org/10.1111/tan.15126

Mack et al. HLA 2023;102(4):501-507 https://doi.org/10.1111/tan.15145
}
