% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permutation.R
\name{permutation}
\alias{permutation}
\title{Permutation for HDANOVA}
\usage{
permutation(object, permute = 1000, perm.type = c("approximate", "exact"))
}
\arguments{
\item{object}{A \code{hdanova} object.}

\item{permute}{Number of permutations to perform (default = 1000).}

\item{perm.type}{Type of permutation to perform, either "approximate" or "exact" (default = "approximate").}
}
\value{
An updated \code{hdanova} object with permutation results.
}
\description{
Permutation testing for HDANOVA. This function performes
permutation testing for the effects in the HDANOVA model and adds them to the
\code{hdanova} object.
}
\examples{
# Load candies data
data(candies)

# Basic HDANOVA model with two factors
mod <- hdanova(assessment ~ candy + assessor, data=candies)
mod <- permutation(mod)
summary(mod)

}
