% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forestplotCombineRegrObj.R
\name{forestplotCombineRegrObj}
\alias{forestplotCombineRegrObj}
\title{Compares different scores in different regression objects.}
\usage{
forestplotCombineRegrObj(
  regr.obj,
  variablesOfInterest.regexp = NULL,
  estimate.txt = NULL,
  add_first_as_ref = FALSE,
  ref_txt = "ref.",
  digits = 1,
  post_process_data = function(x) x,
  is.summary = NULL,
  xlab = NULL,
  zero = NULL,
  xlog = NULL,
  exp = xlog,
  ...
)
}
\arguments{
\item{regr.obj}{A list with all the fits that have variables that are to
be identified through the regular expression}

\item{variablesOfInterest.regexp}{A regular expression identifying the variables
that are of interest of comparing. For instance it can be "(score|index|measure)"
that finds scores in different models that should be compared.}

\item{estimate.txt}{The text of the estimate, usually HR for hazard ratio, OR for
odds ratio}

\item{add_first_as_ref}{If you want that the first variable should be reference for
that group of variables. The ref is a variable with the estimate 1 or 0 depending
if exp() and the confidence interval 0.}

\item{ref_txt}{Text instead of estimate number}

\item{digits}{Number of digits to use for the estimate output}

\item{post_process_data}{A function that takes the data frame just prior to calling `forestplot`
and allows you to manipulate it. Primarily used for changing the `column_label`
that has the names shown in the final plot.}

\item{is.summary}{A vector indicating by \code{TRUE}/\code{FALSE} if
the value is a summary value which means that it will have a different
font-style}

\item{xlab}{x-axis label}

\item{zero}{Indicates what is zero effect. For survival/logistic fits the zero is
1 while in most other cases it's 0.}

\item{xlog}{If TRUE, x-axis tick marks are to follow a logarithmic scale, e.g. for
logistic regression (OR), survival estimates (HR), Poisson regression etc.
\emph{Note:} This is an intentional break with the original \code{forestplot}
function as I've found that exponentiated ticks/clips/zero effect are more
difficult to for non-statisticians and there are sometimes issues with rounding
the tick marks properly.}

\item{exp}{Report in exponential form. Default true since the function was built for
use with survival models.}

\item{...}{Passed to \code{\link[forestplot]{forestplot}()}}
}
\description{
Creates a composite from different regression objects into
one forestplot where you can choose the variables of interest
to get an overview and easier comparison.
}
\examples{
org.par <- par("ask" = TRUE)

# simulated data to test
library(tidyverse)
set.seed(10)
cov <- tibble(ftime = rexp(200),
              fstatus = sample(0:1, 200, replace = TRUE),
              x1 = runif(200),
              x2 = runif(200),
              x3 = runif(200)) |> 
  # Add some column labels
  Gmisc::set_column_labels(x1 = "First variable",
                           x2 = "Second variable")

library(rms)
ddist <- datadist(cov)
options(datadist = "ddist")

fit1 <- cph(Surv(ftime, fstatus) ~ x1 + x2, data = cov)
fit2 <- cph(Surv(ftime, fstatus) ~ x1 + x3, data = cov)

list(`First model` = fit1, 
     `Second model` = fit2) |> 
  forestplotCombineRegrObj(variablesOfInterest.regexp = "(x2|x3)") |> 
  fp_set_style(lines = "steelblue",
               box = "darkblue")

# How to add expressions to the plot label
list(fit1, fit2) |> 
  forestplotCombineRegrObj(variablesOfInterest.regexp = "(x2|x3)",
                           reference.names = c("First model", "Second model"),
                           post_process_data = \(data) {
                             data$column_label[4] <- c(rlang::expr(expression(Fever >= 38.5)))
                             return(data)
                           })

par(org.par)
}
\seealso{
Other forestplot wrappers: 
\code{\link{forestplotRegrObj}()}
}
\concept{forestplot wrappers}
