# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Gets offsetted lines
#'
#' The function calculates new points according to the offset
#' that lie to the left/right of the provided line.
#'
#' @param x A numeric vector containing all the x-elements
#' @param y A numeric vector containing all the y-elements
#' @param offset The offset to add to the line, can be a vector if you
#'  want to use different offsets.
#' @param end_x The x end of the line where the arrow occurrs (if < 0 arrow is skipped)
#' @param end_y The y end of the line where the arrow occurrs (if < 0 arrow is skipped)
#' @param arrow_offset The offset to add to the arrow section if any (if <= 0 arrow is skipped)
#' @param rm_intersect Set to 0 if you want to skip intersection removal, 1 only to remove left or
#'  2 to only remove right. See details for why.
#'
#'  @section Remove intersections:
#'
#'  When the line is wide and the arrow has a narrow curve there may appear an empty triangle due
#'  to polygon cancellation (two polygons within the same are cancel out). This behaviour may be
#'  ugly and the function therefor tries to remove these.
#'
#'  \emph{Note:} it is expensive to check if there are the lineas may intersect at one point,
#'  remove those unexpected, and then adjust the line to the new situation so that the
#'  top and bottom lines match. It can also cause some unexpected behaviour why you may want to
#'  remove this feature if the arrow behaves erratically.
#'
#' @return \code{list(list(x = ..., y = ...))} Returns a list with the right/left
#'  lines that in turn lists with \emph{x} and \emph{y} elements
#' @useDynLib Gmisc
#' @importFrom Rcpp evalCpp
calculateLinesAndArrow <- function(x, y, offset, end_x = -1, end_y = -1, arrow_offset = -1, rm_intersect = 3L) {
    .Call('_Gmisc_calculateLinesAndArrow', PACKAGE = 'Gmisc', x, y, offset, end_x, end_y, arrow_offset, rm_intersect)
}

#' Generates a generalized Bézier line
#'
#' This is a general form of bezier line that can be used for cubic, quadratic,
#' and more advanced Bézier lines.
#'
#' @param ctrl_points The ctrl_points for the bezier control points. This should
#'  either be a \code{matrix} or a \code{data.frame}.
#' @param length_out The length of the return points, i.e. how fine
#'  detailed the points should be.
#'
#' @export
#' @examples
#' library(grid)
#' grid.newpage()
#' l <- gnrlBezierPoints(data.frame(x = c(.1, -.1, .7, 1, 1, 0.1),
#'                                  y = c(.9, 0, 1, .8, .4, .1)),
#'                       length_out = 100)
#' grid.lines(l[,1], l[,2], gp=gpar(col="#550000", lwd = 4))
#'
#' out_sizes <- 4:20
#' clrs <- colorRampPalette(c("orange", "darkblue"))(length(out_sizes))
#' for (i in out_sizes){
#'    l <- gnrlBezierPoints(data.frame(x = c(.1, -.1, .7, 1, 1, 0.1),
#'                                     y = c(.9, 0, 1, .8, .4, .1)),
#'                          length_out = i)
#'    grid.lines(l[,1], l[,2],
#'    gp=gpar(col=clrs[which(i == out_sizes)]))
#' }
gnrlBezierPoints <- function(ctrl_points, length_out = 100L) {
    .Call('_Gmisc_gnrlBezierPoints', PACKAGE = 'Gmisc', ctrl_points, length_out)
}

