% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{getMetaPrograms}
\alias{getMetaPrograms}
\title{Extract consensus gene programs (meta-programs)}
\usage{
getMetaPrograms(
  nmf.res,
  nMP = 10,
  specificity.weight = 5,
  weight.explained = 0.5,
  max.genes = 200,
  metric = c("cosine", "jaccard"),
  hclust.method = "ward.D2",
  min.confidence = 0.5,
  remove.empty = TRUE
)
}
\arguments{
\item{nmf.res}{A list of NMF models obtained from \code{\link{multiNMF}}}

\item{nMP}{Total number of meta-programs}

\item{specificity.weight}{A parameter controlling how specific gene
should be for each program. `specificity.weight=0` no constraint on
specificity, and positive values impose increasing specificity.}

\item{weight.explained}{Fraction of NMF weights explained by selected
genes. For example if weight.explained=0.5, all genes that together
account for 50\% of NMF weights are used to return program signatures.}

\item{max.genes}{Max number of genes for each programs}

\item{metric}{Metric to calculate pairwise similarity between programs}

\item{hclust.method}{Method to build similarity tree between individual programs}

\item{min.confidence}{Percentage of programs in which a gene is seen 
(out of programs in the corresponding program tree branch/cluster), to be 
retained in the consensus metaprograms}

\item{remove.empty}{Whether to remove meta-programs with no genes above 
confidence threshold}
}
\value{
Returns a list with i) 'metaprograms.genes' top genes for each 
    meta-program; ii) 'metaprograms.metrics' dataframe with meta-programs 
    statistics: a) freq. of samples where the MP is present, b) average 
    silhouette width, c) mean similarity (cosine or Jaccard), d) number of 
    genes in MP, e) number of gene programs in MP; iii) 'metaprogram.composition'
    dataframe containing the number of individual for each sample that
    contributed to the consensus MPs; iv) 'programs.similarity': matrix of 
    similarities (Jaccard or cosine) between meta-programs; v) 'programs.tree': 
    hierarchical clustering of meta-programs (hclust tree); vi) 
    'programs.clusters': meta-program identity for each program
}
\description{
Run it over a list of NMF models obtained using \code{\link{multiNMF}}; it will 
determine gene programs that are consistently observed across samples 
and values of k.
}
\examples{
library(Seurat)
data(sampleObj)
geneNMF_programs <- multiNMF(list(sampleObj), k=5)
geneNMF_metaprograms <- getMetaPrograms(geneNMF_programs, nMP=3)

}
