% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QUANTILE.R
\name{QUANTILE}
\alias{QUANTILE}
\title{Quantile function}
\usage{
QUANTILE(p, param, family, size = 0)
}
\arguments{
\item{p}{values at which the quantile needs to be computed; between 0 and 1; (e.g 0.01, 0.05)}

\item{param}{parameters of the distribution; (1 x p)}

\item{family}{distribution name; run the function distributions() for help}

\item{size}{additional parameter for some discrete distributions; run the command distributions() for help}
}
\value{
\item{q}{quantile/VAR}
}
\description{
This function computes the quantile function of a univariate distribution, excluding zero-inflated.
}
\examples{
family = "gaussian"

theta = matrix(c(-1.5, 1.7),1,2) ;
quantile = QUANTILE(0.01, theta, family)
print('Quantile : ')
print(quantile)

}
