% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.gwlfit.R
\name{plot.gwlfit}
\alias{plot.gwlfit}
\title{Plot method for gwlfit object}
\usage{
\method{plot}{gwlfit}(x, ...)
}
\arguments{
\item{x}{a \code{gwlfit} object returned by \code{\link[=gwl_fit]{gwl_fit()}}}

\item{...}{ellipsis for S3 method compatibility}
}
\value{
a ggplot
}
\description{
Plot method for gwlfit object
}
\examples{

predictors <- matrix(data = rnorm(2500), 50,50)
y_value <- sample(1:1000, 50)
coords <- data.frame("Lat" = rnorm(50), "Long" = rnorm(50))
distance_matrix <- compute_distance_matrix(coords)

my.gwl.fit <- gwl_fit(bw = 20,
                      x.var = predictors, 
                      y.var = y_value,
                      kernel = "bisquare",
                      dist.mat = distance_matrix, 
                      alpha = 1, 
                      adaptive = TRUE, 
                      progress = TRUE,
                      nfolds = 5)

plot(my.gwl.fit)

}
