% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GRAND.R
\name{LSM.Gen}
\alias{LSM.Gen}
\title{Generate Latent Space Model Network}
\usage{
LSM.Gen(n, k, K, avg.d = NULL)
}
\arguments{
\item{n}{Integer. Number of nodes in the network.}

\item{k}{Integer. Dimension of the latent space.}

\item{K}{Integer. Number of communities/groups.}

\item{avg.d}{Numeric. Target average node degree. If NULL, no degree adjustment is performed. Default is "NULL".}
}
\value{
A list containing:
\itemize{
  \item A: Adjacency matrix of the generated network
  \item g: Graph object of the generated network
  \item P: Probability matrix of the generated network
  \item alpha: Node-specific intercept parameters
  \item Z: Latent positions in k-dimensional space
  \item idx: Community assignments for each node
}
}
\description{
Generates a random network following LSM (Latent Space Model) with specified parameters.
  LSM assumes that each node has a latent position in a k-dimensional space, and edge probabilities
  depend on the inner products between these latent positions.
}
\details{
Generate Latent Space Model Network


  The Latent Space Model generates networks based on the following process:
  \enumerate{
    \item Node-specific intercept parameters: \eqn{\alpha_i \sim \mathsf{Unif}(1, 3)}, then transformed as \eqn{\alpha_i = -\alpha_i/2}
    \item Community assignments: Each node is randomly assigned to one of K communities with equal probability
    \item Community centers: \eqn{\mu_g} sampled uniformly from \eqn{[-1, 1]^k} hypercube
    \item Latent positions: \eqn{Z_i \sim \mathcal{N}_{[-2, 2]}(\mu_{g_i}, I_k)} where \eqn{\mu_{g_i}} is the community center for node i's community
    \item Edge probabilities: \deqn{P_{ij} = \text{logit}^{-1}(\alpha_i + \alpha_j + Z_i^\top Z_j) = \frac{1}{1 + \exp(-(\alpha_i + \alpha_j + Z_i^\top Z_j))}}
    \item Adjacency matrix: \eqn{A_{ij} \sim \mathsf{Bern}(P_{ij})} for \eqn{i < j}, with \eqn{A_{ii} = 0} and \eqn{A_{ji} = A_{ij}}
  }
  If \code{avg.d} is specified, the edge probabilities are scaled to achieve the target average node degree.
  
  For more details, see the "simulation studies" section of Ma, Ma, and Yuan (2020), noting that our implementation has slight differences.
}
\examples{
# Generate a network with 400 nodes, 2D latent space, 3 communities
network <- LSM.Gen(n = 400, k = 2, K = 3)
# Generate with target average degree of 40
network2 <- LSM.Gen(n = 400, k = 2, K = 3, avg.d = 40)
}
\references{
P. D. Hoff, A. E. Raftery, and M. S. Handcock. Latent space approaches to social network analysis. 
  Journal of the American Statistical Association, 97(460):1090–1098, 2002.
  
  Z. Ma, Z. Ma, and H. Yuan. Universal latent space model fitting for large networks with edge covariates.
  Journal of Machine Learning Research, 21(4):1–67, 2020.
  
  S. Liu, X. Bi, and T. Li. GRAND: Graph Release with Assured Node Differential Privacy. 
  arXiv preprint arXiv:2507.00402, 2025.
}
