% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flex_ld_decay.R
\name{flex_LD_decay}
\alias{flex_LD_decay}
\title{flex_LD_decay function}
\usage{
flex_LD_decay(
  ld_data,
  interactive = TRUE,
  user_colors = NULL,
  user_title = "LD Decay Plot",
  user_x_title = "Distance (Mb)",
  user_y_title = "R-squared (LD)",
  user_legend_title = "Chromosome",
  user_plot_theme = theme_minimal(),
  user_plot_theme_specs = theme(legend.title = element_text(size = 10), legend.text =
    element_text(size = 10), title = element_text(size = 15), axis.text.x =
    element_text(size = 10), axis.title.x = element_text(size = 10), axis.text.y =
    element_text(size = 10), axis.title.y = element_text(size = 10)),
  user_base = 1e+06,
  user_smoothing = "loess",
  add_smoothing = FALSE,
  add_smoothing_per_chromosome = FALSE,
  ...
)
}
\arguments{
\item{ld_data}{Data frame containing LD information.}

\item{interactive}{Logical. If \code{TRUE}, returns an interactive plot using \code{plotly}.
Default is \code{TRUE}.}

\item{user_colors}{Character vector of colors for chromosomes. If \code{NULL}, default
colors are used. Default is \code{NULL}.}

\item{user_title}{Character. Title of the plot. Default is \code{"LD Decay Plot"}.}

\item{user_x_title}{Character. X-axis label. Default is \code{"Distance (Mb)"}.}

\item{user_y_title}{Character. Y-axis label. Default is \code{"R-squared (LD)"}.}

\item{user_legend_title}{Character. Legend title. Default is \code{"Chromosome"}.}

\item{user_plot_theme}{A ggplot2 theme object. Default is \code{theme_minimal()}.}

\item{user_plot_theme_specs}{Additional theme specifications applied to the plot.
Default is a theme object with custom font sizes.}

\item{user_base}{Numeric. Scaling factor for distance (e.g., 1e6 for Mb). Default is \code{1e6}.}

\item{user_smoothing}{Character. Smoothing method to use in \code{geom_smooth}. Default is \code{"loess"}.}

\item{add_smoothing}{Logical. If \code{TRUE}, adds a smoothing curve to the plot. Default is \code{FALSE}.}

\item{add_smoothing_per_chromosome}{Logical. If \code{TRUE}, adds separate smoothing
curves for each chromosome. Default is \code{FALSE}.}

\item{...}{Additional arguments passed to \code{geom_smooth} (e.g., \code{span}, \code{se}, etc.).}
}
\value{
A ggplot object (static plot) or a plotly object (interactive plot),
depending on the value of \code{interactive}.
}
\description{
This function generates a linkage disequilibrium (LD) decay plot based on input LD data.
It supports both static and interactive visualization with customizable aesthetics, themes,
and optional smoothing curves.
}
\examples{
library(ggplot2)
library(plotly)
library(dplyr)
library(nortest)
library(ggforce)
library(reshape2)
library(gridExtra)
library(grid)
library(cowplot)
# Load example data
snp_ld_data <- example_data7

# Basic plot
flex_LD_decay(snp_ld_data)

# Add a general smoothing curve
flex_LD_decay(snp_ld_data, add_smoothing = TRUE)

# Add smoothing per chromosome
flex_LD_decay(snp_ld_data, add_smoothing = TRUE, add_smoothing_per_chromosome = TRUE)

# Customize smoothing parameters
flex_LD_decay(snp_ld_data, add_smoothing = TRUE, span = 0.5, se = FALSE)

# Use generalized additive model (GAM) for smoothing
flex_LD_decay(snp_ld_data, user_smoothing = "gam", add_smoothing = TRUE, 
add_smoothing_per_chromosome = TRUE)
}
