% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMCMC.R
\name{plotMCMC}
\alias{plotMCMC}
\title{MCMC trace-plots}
\usage{
plotMCMC(dat, datMCMC, estimator = "xi")
}
\arguments{
\item{dat}{input data as a list containing survival data sub-list
\code{survObj} with two vectors (\code{event} and \code{time}), clinical
variable matrix \code{x0}, cluster-specific covariates \code{X}, and
proportions data matrix \code{proportion}}

\item{datMCMC}{returned object from the main function \code{GPTCM()}}

\item{estimator}{print estimators, one of
\code{c("beta", "zeta", "gamma", "eta")}}
}
\value{
A \code{ggplot2::ggplot} object. See \code{?ggplot2::ggplot} for more
details of the object.
}
\description{
Trace-plots of regression coefficients over MCMC iterations
}
\examples{

# simulate data
set.seed(123)
n <- 200 # subjects
p <- 10 # variable selection predictors
L <- 3 # cell types
dat <- simData(n, p, L)

# run a Bayesian GPTCM model: GPTCM-Ber2
fit <- GPTCM(dat, nIter = 10, burnin = 0)

plotMCMC(dat, datMCMC = fit, estimator = "xi")

}
\references{
Zhao Z, Kızılaslan F, Wang S, Zucknick M (2025). \emph{Generalized promotion time cure model: A new modeling framework to identify cell-type-specific genes and improve survival prognosis}. arXiv:2509.01001
}
