\name{g.analyse}
\alias{g.analyse}
\title{
  Function to analsyse meta-data generated by \link{g.getmeta} and \link{g.impute}
}
\description{
  Analyses the output from other functions within the packages to generate a basic
  descriptive summary for each accelerometer data file. Analyses include: Average 
  acceleration per day, per measurement, L5M5 analyses (assessment of the five
  hours with lowest acceleration and with highest acceleration). Further, the 
  traditionally popular variable MVPA is automatically extracted in six variants:
  without bout criteria in combination with epoch = epoch length as defined in
  g.getmeta (first value of the input argument windowsizes), 1 minute,
  and 5 minutes, and for bout durations 1 minute, 5 minutes or 10 minutes in
  combination with the epoch length as defined in g.getmeta.
}
\usage{
  g.analyse(I, C, M, IMP, params_247 = c(), params_phyact = c(),
                      params_general = c(), params_cleaning = c(),
                      quantiletype = 7, myfun = c(), ID, ...)
}
\arguments{
  \item{I}{
    the output from function \link{g.inspectfile}
  }
  \item{C}{
    the output from function \link{g.calibrate}
  }
  \item{M}{
    the output from function \link{g.getmeta}
  }
  \item{IMP}{
    the output from function \link{g.impute}
  }
  \item{params_247}{
    See \link{GGIR}
  }
  \item{params_phyact}{
    See \link{GGIR}
  }
  \item{params_general}{
    See \link{GGIR}
  }
  \item{params_cleaning}{
    See \link{GGIR}
  }
  \item{quantiletype}{
    type of quantile function to use (default recommended). For details, see 
    quantile function in STATS package
  }
  \item{myfun}{
    External function object to be applied to raw data, see \link{g.getmeta}.
  }
  \item{ID}{
    ID extracted in g.part2.
  }
  \item{...}{
     Any argument used in the previous version of g.analyse, which will now
     be used to overrule the arguments specified with the parameter objects.
  }
}
\value{
  g.analyse generated two data,franeL
  \item{\code{summary}}{summary for the file that was analysed}
  \item{\code{daysummary}}{summary per day for the file that was analysed}
  These data.frames are used by function g.report.part2 to generate csv reports.
  An exaplantion of all the columns in the data.frame and subsequent csv reports
  can be found in the package vignette (Output part 2).
}
\examples{
  data(data.getmeta)
  data(data.inspectfile)
  data(data.calibrate)
  \dontrun{
    #inspect file:
    I = g.inspectfile(datafile)
    
    #autocalibration:
    C = g.calibrate(datafile) 
    
    #get meta-data:
    M = g.getmeta(datafile, desiredtz = "Europe/London", 
    windowsizes = c(5, 900, 3600),
    daylimit = FALSE, offset = c(0, 0, 0), 
    scale = c(1, 1, 1), tempoffset = c(0, 0, 0))
  }
  #impute meta-data:
  IMP = g.impute(M = data.getmeta, I = data.inspectfile, ID = "01wk0")
  
  #analyse and produce summary:
  A = g.analyse(I = data.inspectfile, C = data.calibrate,
  M = data.getmeta, IMP, ID = "01wk0")
}
\keyword{internal}
\author{
  Vincent T van Hees <v.vanhees@accelting.com>
}