% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmgceclassfunctions.R
\name{summary.lmgce}
\alias{summary.lmgce}
\title{Summarise a linear regression model via generalized cross entropy fit}
\usage{
\method{summary}{lmgce}(
  object,
  call = TRUE,
  correlation = FALSE,
  symbolic.cor = FALSE,
  ci.level = NULL,
  ci.method = c("z", "percentile", "basic"),
  boot.B = ifelse(object$boot.B == 0, 100, object$boot.B),
  boot.method = object$boot.method,
  ...
)
}
\arguments{
\item{object}{Fitted \code{\link{lmgce}} model object.}

\item{call}{Boolean value. if \code{TRUE}, the call used is returned.
The default is \code{model = TRUE}.}

\item{correlation}{Boolean value. if \code{TRUE}, the correlation
matrix of the estimated parameters is returned and printed.}

\item{symbolic.cor}{Boolean value. if \code{TRUE}, print the correlations in
a symbolic form (see \code{\link[stats]{symnum}}) rather than as numbers.}

\item{ci.level}{the confidence level (0,1) required to compute the confidence
interval. The default is \code{ci.level = NULL} which results in the omission
 of the confidence interval.}

\item{ci.method}{method used to compute a confidence interval. One of
c("z","percentile", "basic"). The default is \code{ci.method = "z"}.}

\item{boot.B}{A single positive integer greater or equal to 10 for the number
of bootstrap replicates for the computation of the bootstrap confidence
interval(s), to be used when \code{method = c("percentile", "basic")} and
when \code{object} was created with \code{boot.B = 0}. The default is
\code{boot.B = 100} when the \code{object} has no previous sampling information
and \code{boot.B = object$boot.B} otherwise, which corresponds to
the \code{boot.B} given to \code{lmgce} when the \code{object} was created.}

\item{boot.method}{Method used for bootstrapping. One of
\code{c("residuals", "cases", "wild")} which corresponds to resampling on
residuals, on individual cases or on residuals multiplied by a N(0,1) variable,
respectively. The default is \code{boot.method = object$boot.method}.}

\item{...}{additional arguments.}
}
\value{
The function \code{summary.lmgce} computes and returns a list of
summary statistics of the fitted \code{\link{lmgce}} linear model given in
\code{object}, using the components (list elements) "call" and "terms" from
its argument, plus

\item{residuals}{the residuals, that is response minus fitted values.}
\item{coefficients}{a \eqn{p \times 4} matrix, where \eqn{p} is the number of
non-aliased coefficients, with columns for the estimated coefficient, its
standard error, z-statistic and corresponding (two-sided)
p-value. Aliased coefficients are omitted.}
\item{support}{a \eqn{p \times 3} matrix with columns for the normalized
entropy (NormEnt), and lower (LL) and upper (UL) limits for each of the
\eqn{K+1} support spaces.}
\item{aliased}{named logical vector showing if the original coefficients are
aliased.}
\item{sigma}{the square root of the estimated variance of the random error.}
\item{df}{degrees of freedom, a 3-vector \eqn{(p, n - p)} the first being the
number of non-aliased coefficients, the last being the \eqn{p} minus the
number of included individuals \eqn{n}.}
\item{r.squared}{\eqn{R^2}, the ‘fraction of variance explained by the model’}
\item{adj.r.squared}{the above \eqn{R^2} statistic ‘adjusted’, penalizing for
higher \eqn{p}.}
\item{cov.unscaled}{a \eqn{p \times p} matrix of covariances of the
\eqn{\hat \beta}}
\item{support.stdUL}{when applicable, the upper limit of the standardized
support chosen, when \code{support.method = "standardized"} or the factor used
 when \code{support.method = "ridge"}.}
\item{support.method}{method chosen for the support's limits}
\item{nep}{the normalized entropy of the model.}
\item{nep.cv.mean}{the cross-validation normalized entropy of the model.}
\item{nep.cv.sd}{the standard deviation of the cross-validation normalized
entropy of the model.}
\item{error}{the error measure chosen}
\item{error.which}{which criterion/standardized/factor support was used}
\item{error.measure}{the value of the error measure}
\item{error.measure.cv.mean}{the cross-validation value of the error measure}
\item{error.measure.cv.sd}{the standard deviation of the cross-validation
value of the error measure}
\item{correlation}{the correlation matrix corresponding to the above
cov.unscaled, if \code{correlation = TRUE} is specified.}
\item{symbolic.cor}{(only if \code{correlation = TRUE}) The value of the
argument \code{symbolic.cor}.}
\item{na.action}{from object, if present there.}
}
\description{
summary method for class \code{\link{lmgce}}. Function used to produce
summary information from a fitted linear regression model via generalized
cross entropy as represented by \code{object} of class \code{\link{lmgce}}.
}
\examples{
\donttest{
res_gce_package <-
  lmgce(y ~ .,
        data = dataGCE,
        boot.B = 50,
        seed = 230676)
}

sm_res_gce_package <- summary(res_gce_package)

str(sm_res_gce_package)

sm_res_gce_package$coefficients

}
\author{
Jorge Cabral, \email{jorgecabral@ua.pt}
}
