% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neaggingclassfunctions.R
\name{plot.neagging}
\alias{plot.neagging}
\title{Plot Diagnostics for a \code{\link{neagging}} Object}
\usage{
\method{plot}{neagging}(x, which = 1, ...)
}
\arguments{
\item{x}{Fitted \code{neagging} model object.}

\item{which}{Numbers 1 or 2.}

\item{...}{additional arguments.}
}
\value{
A \code{ggplot} object.
}
\description{
Two plots (selectable by \code{which}) are currently available to
evaluate a \code{\link{neagging}} object: plots of the estimates and in
sample error against the number of bootstrap samples aggregated.
}
\examples{
\donttest{
res_gce_package <-
  lmgce(y ~ .,
        data = dataGCE,
        boot.B = 50,
        seed = 230676)

res_neagging <- neagging(res_gce_package)

plot(res_neagging)
}

}
\seealso{
\code{\link[GCEstim]{lmgce}}, \code{\link[GCEstim]{tsbootgce}} and
\code{\link[GCEstim]{neagging}}
}
\author{
Jorge Cabral, \email{jorgecabral@ua.pt}
}
