% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.lmgceclassfunctions.R
\name{plot.cv.lmgce}
\alias{plot.cv.lmgce}
\title{Plot Diagnostics for a \code{\link{cv.lmgce}} Object}
\usage{
\method{plot}{cv.lmgce}(x, which = 1, ncol = 1, scales = "free", ...)
}
\arguments{
\item{x}{Fitted \code{cv.lmgce} model object.}

\item{which}{A subset of the numbers 1:1.}

\item{ncol}{Number of columns of the plot (see
\code{\link[ggplot2]{facet_wrap}}).}

\item{scales}{One of c("free", "fixed") (see
\code{\link[ggplot2]{facet_wrap}}).}

\item{...}{additional arguments.}
}
\value{
A \code{ggplot} object.
}
\description{
One plot (selectable by \code{which}) is currently available to
evaluate a \code{\link{cv.lmgce}} object. The plot depicts the error change
with the combination of different arguments of \code{\link{cv.lmgce}}.
}
\examples{
\donttest{
res.cv.lmgce <-
  cv.lmgce(y ~ .,
           data = dataGCE)

plot(res.cv.lmgce)
}

}
\seealso{
\code{\link[GCEstim]{cv.lmgce}}
}
\author{
Jorge Cabral, \email{jorgecabral@ua.pt}
}
