% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fngendata.R
\name{fngendata}
\alias{fngendata}
\title{Data generating function}
\usage{
fngendata(
  n,
  bin.k = 0,
  bin.prob = NULL,
  cont.k = 5,
  y.gen.bin.k = 0,
  y.gen.bin.beta = NULL,
  y.gen.bin.prob = NULL,
  y.gen.cont.beta = c(2, 4, 6, 8, 10),
  y.gen.cont.mod.k = 0,
  y.gen.cont.mod.beta = matrix(c(-2, 2), 1, 2, byrow = TRUE),
  y.gen.bin.mod.prob = c(0.5),
  y.gen.cont.sp.k = 0,
  y.gen.cont.sp.groups = 2,
  y.gen.cont.sp.rho = 0.2,
  y.gen.cont.sp.dif = 1,
  intercept.beta = 0,
  Xgenerator.method = "simstudy",
  corMatrix = 100,
  rho = NULL,
  corstr = NULL,
  condnumber = 1,
  mu = 0,
  muvect = NULL,
  sd = 1,
  sdvect = NULL,
  error.dist = "normal",
  error.dist.mean = 0,
  error.dist.sd = 1,
  error.dist.snr = NULL,
  error.dist.df = 2,
  dataframe = TRUE,
  seed = NULL
)
}
\arguments{
\item{n}{Number of individuals.}

\item{bin.k}{Number of binary variables not used for generating y.}

\item{bin.prob}{A vector of probabilities with length equal to \code{bin.k}.}

\item{cont.k}{Number of continuous variables not used for generating y.}

\item{y.gen.bin.k}{Number of binary variables used for generating y.}

\item{y.gen.bin.beta}{A vector of coefficients with length equal to \code{bin.k}
used to generate y.}

\item{y.gen.bin.prob}{A vector of probabilities with length equal
to \code{y.gen.bin.k}.}

\item{y.gen.cont.beta}{A vector of coefficients with length equal to \code{cont.k}
used to generate y.}

\item{y.gen.cont.mod.k}{Experimental}

\item{y.gen.cont.mod.beta}{Experimental}

\item{y.gen.bin.mod.prob}{Experimental}

\item{y.gen.cont.sp.k}{Experimental}

\item{y.gen.cont.sp.groups}{Experimental}

\item{y.gen.cont.sp.rho}{Experimental}

\item{y.gen.cont.sp.dif}{Experimental}

\item{intercept.beta}{Value for the constant used to generate y.}

\item{Xgenerator.method}{Method used to generate X data ( \code{"simstudy"}
or \code{"svd"}).}

\item{corMatrix}{A positive number for alphad
(see \code{\link[clusterGeneration]{rcorrmatrix}}), NULL or a correlation
 matrix to be used when \code{Xgenerator} is \code{"simstudy"}.}

\item{rho}{Correlation coefficient, \code{-1 <= rho <= 1}. Use when
\code{Xgenerator} is \code{"simstudy"} and \code{corMatrix} is NULL.}

\item{corstr}{correlation structure (\code{"ind"}, \code{"cs"} or
\code{"ar1"}) (see \code{\link[simstudy]{genCorData}}) to be used when
\code{Xgenerator} is \code{"simstudy"} and \code{corMatrix} is NULL.}

\item{condnumber}{A value for the condition number of the X matrix to be used
when \code{Xgenerator} is \code{"svd"}.}

\item{mu}{The mean of the variables. To be used when all variables have the
same mean.}

\item{muvect}{A vector of means. To be used when variables have different means.
The length of \code{muvect} must be \code{k}.}

\item{sd}{Standard deviation of the variables. To be used when all variables
have the same standard deviation.}

\item{sdvect}{A vector of standard deviations. To be used when variables have
different standard deviations. The length of \code{sdvect} must be \code{k}.}

\item{error.dist}{Distribution of the error. \code{"normal"} for normal
distribution or \code{"t"} for t-student distribution.}

\item{error.dist.mean}{Mean value used when \code{error.dist} is
\code{"normal"}.}

\item{error.dist.sd}{Standard deviation value used when \code{error.dist} is
\code{"normal"}.}

\item{error.dist.snr}{Signal to noise ratio. If not \code{NULL}, the value of
\code{error.dist.sd} will be ignored and it will be determined accordingly.}

\item{error.dist.df}{Degrees of freedom used when \code{error.dist} is
\code{"t"}.}

\item{dataframe}{Logical. If \code{TRUE}, the default, returns a
\code{data.frame} else returns a \code{list}.}

\item{seed}{A seed for reproducibility.}
}
\value{
A \code{data.frame} or a \code{list} composed of a matrix of
independent variables values (X), a vector of the dependent variable values
(y), a vector of coefficient values (coefficients), a vector of non-zero
coefficients (y.coefficients), and a vector of the error values (epsilon).
}
\description{
Generates data
}
\examples{

dataGCEstim <- fngendata(
  n = 100, cont.k = 2,
  y.gen.cont.beta = c(3, 6, 9),
  intercept.beta = 1,
  Xgenerator.method = "svd", condnumber = 50,
  mu = 0, sd = 1,
  error.dist = "normal", error.dist.mean = 0, error.dist.snr = 5,
  dataframe = TRUE, seed = 230676)

summary(dataGCEstim)

}
\author{
Jorge Cabral, \email{jorgecabral@ua.pt}
}
