% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Fuzzy_Square_26102018.R
\name{Fuzzy.Square}
\alias{Fuzzy.Square}
\title{Calculates numerically the square of a fuzzy number}
\usage{
Fuzzy.Square(F1L, breakpoints = 100, plot = FALSE)
}
\arguments{
\item{F1L}{a fuzzy number.}

\item{breakpoints}{a positive arbitrary integer representing the number of breaks chosen to build the numerical alpha-cuts. It is fixed to 100 by default.}

\item{plot}{fixed by default to "FALSE". plot="TRUE" if a plot of the fuzzy number is required.}
}
\value{
A matrix composed by 2 vectors representing the numerical left and right alpha-cuts. For this output, is.alphacuts = TRUE.
}
\description{
Calculates numerically the square of a fuzzy number
}
\examples{
 X <- TrapezoidalFuzzyNumber(1,2,3,4)
Fuzzy.Square(X, plot=TRUE)
}
