/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.featureExtraction;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ohdsi.featureExtraction.StringUtilities;

public class Row {
    private List<String> cells;
    private Map<String, Integer> fieldName2ColumnIndex;

    public Row() {
        this.fieldName2ColumnIndex = new HashMap<String, Integer>();
        this.cells = new ArrayList<String>();
    }

    public Row(List<String> cells, Map<String, Integer> fieldName2ColumnIndex) {
        this.cells = cells;
        this.fieldName2ColumnIndex = fieldName2ColumnIndex;
    }

    public Row(Row row) {
        this.cells = new ArrayList<String>(row.cells);
        this.fieldName2ColumnIndex = new HashMap<String, Integer>(row.fieldName2ColumnIndex);
    }

    public String get(String fieldName) {
        int index;
        try {
            index = this.fieldName2ColumnIndex.get(fieldName);
        }
        catch (NullPointerException e) {
            throw new RuntimeException("Field \"" + fieldName + "\" not found");
        }
        if (this.cells.size() <= index) {
            return null;
        }
        return this.cells.get(index);
    }

    public List<String> getFieldNames() {
        ArrayList<String> names = new ArrayList<String>(this.fieldName2ColumnIndex.size());
        for (int i = 0; i < this.fieldName2ColumnIndex.size(); ++i) {
            names.add(null);
        }
        for (Map.Entry<String, Integer> entry : this.fieldName2ColumnIndex.entrySet()) {
            names.set(entry.getValue(), entry.getKey());
        }
        return names;
    }

    public int getInt(String fieldName) {
        return Integer.parseInt(this.get(fieldName).trim());
    }

    public long getLong(String fieldName) {
        return Long.parseLong(this.get(fieldName));
    }

    public double getDouble(String fieldName) {
        return Double.parseDouble(this.get(fieldName));
    }

    public void add(String fieldName, String value) {
        this.fieldName2ColumnIndex.put(fieldName, this.cells.size());
        this.cells.add(value);
    }

    public void add(String fieldName, int value) {
        this.add(fieldName, Integer.toString(value));
    }

    public void add(String fieldName, boolean value) {
        this.add(fieldName, Boolean.toString(value));
    }

    public void add(String fieldName, double value) {
        this.add(fieldName, Double.toString(value));
    }

    public void add(String fieldName, long value) {
        this.add(fieldName, Long.toString(value));
    }

    public void set(String fieldName, String value) {
        this.cells.set(this.fieldName2ColumnIndex.get(fieldName), value);
    }

    public void set(String fieldName, int value) {
        this.set(fieldName, Integer.toString(value));
    }

    public void set(String fieldName, long value) {
        this.set(fieldName, Long.toString(value));
    }

    public void set(String fieldName, double value) {
        this.set(fieldName, Double.toString(value));
    }

    public List<String> getCells() {
        return this.cells;
    }

    protected Map<String, Integer> getfieldName2ColumnIndex() {
        return this.fieldName2ColumnIndex;
    }

    public String toString() {
        ArrayList<String> data = new ArrayList<String>(this.cells);
        for (String fieldName : this.fieldName2ColumnIndex.keySet()) {
            int index = this.fieldName2ColumnIndex.get(fieldName);
            if (data.size() <= index) continue;
            data.set(index, "[" + fieldName + ": " + (String)data.get(index) + "]");
        }
        return StringUtilities.join(data, ",");
    }

    public void remove(String field) {
        Integer index = this.fieldName2ColumnIndex.remove(field);
        this.cells.remove(index);
        HashMap<String, Integer> tempMap = new HashMap<String, Integer>();
        for (Map.Entry<String, Integer> entry : this.fieldName2ColumnIndex.entrySet()) {
            if (entry.getValue() > index) {
                tempMap.put(entry.getKey(), entry.getValue() - 1);
                continue;
            }
            tempMap.put(entry.getKey(), entry.getValue());
        }
        this.fieldName2ColumnIndex = tempMap;
    }

    public int size() {
        return this.cells.size();
    }

    public void upperCaseFieldNames() {
        HashMap<String, Integer> tempMap = new HashMap<String, Integer>();
        for (Map.Entry<String, Integer> entry : this.fieldName2ColumnIndex.entrySet()) {
            tempMap.put(entry.getKey().toUpperCase(), entry.getValue());
        }
        this.fieldName2ColumnIndex = tempMap;
    }
}

