% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulations.R
\name{run_all_simulations}
\alias{run_all_simulations}
\title{Run every simulation in an FSK object}
\usage{
run_all_simulations(
  fsk_object,
  run_visualization = FALSE,
  copy_workspace = FALSE,
  workspace_mode = "all",
  inject_to_global = FALSE
)
}
\arguments{
\item{fsk_object}{Instance of FSK2R}

\item{run_visualization}{Whether to call the visualization script. FALSE
by default.}

\item{copy_workspace}{Whether to copy the simulation workspace to the user's
working directory. FALSE by default.}

\item{workspace_mode}{What to copy when copy_workspace=TRUE. Options: "all" 
(copy everything), "generated" (copy only files created during simulation),
"modified" (copy only files modified during simulation). Default is "all".}

\item{inject_to_global}{Whether to inject simulation variables into the 
user's global environment for seamless model chaining. FALSE by default
for backward compatibility.}
}
\value{
A named list with the results of all simulations
}
\description{
Runs every simulation defined in the FSK object. This includes
the ones originally included in the FSK container, as well as
the ones added using set_new_simulation().
}
