% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_options.R
\name{table_options}
\alias{table_options}
\title{Table aesthetics and output options.}
\usage{
table_options(
  row.FIAname = FALSE,
  col.FIAname = FALSE,
  row.orderby = NULL,
  col.orderby = NULL,
  row.add0 = FALSE,
  col.add0 = FALSE,
  rowlut = NULL,
  collut = NULL,
  row.classify = NULL,
  col.classify = NULL,
  rawonly = FALSE,
  raw.keep0 = FALSE,
  rowgrp = FALSE,
  rowgrpnm = NULL,
  rowgrpord = NULL,
  totals = TRUE,
  allin1 = FALSE,
  metric = FALSE,
  estround = 1,
  pseround = 2,
  estnull = "--",
  psenull = "--",
  row.NAname = "Other",
  col.NAname = "Other",
  divideby = NULL,
  spcdname = "COMMON_SCIENTIFIC",
  ...
)
}
\arguments{
\item{row.FIAname}{Logical. If TRUE, retrieves default FIA reference names
for rowvar located in ref_codes data frame. Names are only available
for certain variables (Check sort(unique(ref_codes$VARIABLE)) for
available names.  If row.FIAname = TRUE and rowvar is in ref_codes,
the rowvar name is used for the output table, and the rowvar code is used to
sort.}

\item{col.FIAname}{Logical. If TRUE, retrieves default FIA reference names
for colvar located in ref_codes data frame. Names are only available
for certain variables. Check: sort(unique(ref_codes$VARIABLE)) for
available names.  If col.FIAname = TRUE and rowvar is in ref_codes,
the colvar name is used for the output table, and the colvar code is used to
sort.}

\item{row.orderby}{String. Optional. Name of variable to sort table rows.
Both the rowvar and row.orderby variables must be included in the same input
data.frame.  if NULL, and row.FIAname=FALSE or rowvar is not in
ref_codes, the rows are ordered by rowvar.}

\item{col.orderby}{String. Optional. Name of variable to sort table columns.
Both the colvar and col.orderby variables must be included in the same input
data.frame.  if NULL, and col.FIAname=FALSE or colvar is not in
ref_codes, the columns are ordered by colvar.}

\item{row.add0}{Logical. If TRUE, include rows with 0 values to the output
table.}

\item{col.add0}{Logical. If TRUE, include columns with 0 values to the
output table.}

\item{rowlut}{Data frame. A lookup table with variable codes and code names
to include as rows of output table (See notes for more information and
format).}

\item{collut}{Data frame. A lookup table with variable codes and code names
to include as columns of output table (See notes for more information and
format).}

\item{row.classify}{Data frame (if categorical) or Vector (if continuous). 
If clasifying categories, input a dataframe with two columns. The columns
must be named 'FROM' and 'TO', or include the rowvar and the classified 
column name. If classifying continuous values, input a vector of class breaks 
for row values (e.g., c(0,25,50): >=0 and < 25 (0-25); >=25 and <50 (25-50), 
>=50 (50+)).}

\item{col.classify}{Data frame (if categorical) or Vector (if continuous). 
If clasifying categories, input a dataframe with two columns. The columns
must be named 'FROM' and 'TO', or include the colvar and the classified 
column name. If classifying continuous values, input a vector of class breaks 
for row values (e.g., c(0,25,50): >=0 and < 25 (0-25); >=25 and <50 (25-50), 
>=50 (50+)).}

\item{rawonly}{Logical. If TRUE, only rawdata are output. If dataset
includes many estimation units, and only raw data tables are desired, it is
more efficient to output raw data only.}

\item{raw.keep0}{Logical. If TRUE, keep 0 values in raw data tables.}

\item{rowgrp}{Logical. If TRUE, appends row groups to first column of table.
Only available if group category exists in ref_codes table or defined in
rowgrpnm (e.g., FORTYPGRPCD, OWNGRPCD).}

\item{rowgrpnm}{String. Name of variable for grouping rowvar. Variable must
be included in same input table as rowvar.}

\item{rowgrpord}{String. Name of variable to sort row group variable.
Variable must be included in same input table as rowgrpnm.}

\item{totals}{Logical. If TRUE, returns total estimate (mean * AREAUSED).}

\item{allin1}{Logical. If TRUE, both estimates and percent sample error are
output in one table as: estimates (percent sample error).}

\item{metric}{Logical. If TRUE, output if returned in metric units.}

\item{estround}{Integer. Number of decimal places for estimates.}

\item{pseround}{Integer. Number of decimal places for percent sampling
error.}

\item{estnull}{Number or character. The number or symbol to use to indicate
'not sampled' for estimate.}

\item{psenull}{Number or character. The number or symbol to use to indicate
'not sampled' for percent standard error.}

\item{row.NAname}{String. The name to use for NA values for rows.}

\item{col.NAname}{String. String. The name to use for NA values for columns.}

\item{divideby}{String. Conversion number for output ('hundred', 'thousand',
'million').}

\item{spcdname}{String. Type of name to use for species in tables ('COMMON', 
'SCIENTIFIC', SYMBOL', 'COMMON_SCIENTIFIC', 'NONE').}

\item{...}{For extendibility.}
}
\value{
A list of user-supplied parameters and parameter values for outputting
tables with custom aesthetics.
}
\description{
Returns a list of user-supplied parameters and parameter values for outputting
tables with custom aesthetics.
}
\details{
If no parameters, an empty list is returned.
}
\examples{

table_options(row.FIAname = TRUE, col.FIAname = TRUE)

}
\author{
Grayson W. White
}
\keyword{options}
