
#' @description Perform optimal transport based tests in factorial designs as introduced in Groppe et al. (2025) via the [`FDOTT()`] function.
#' These tests are inspired by ANOVA and its nonparametric counterparts. They allow for testing linear relationships in factorial designs
#' between finitely supported probability measures on a metric space.
#' Such relationships include equality of all measures (no treatment effect), interaction effects between a number of factors,
#' as well as main and simple factor effects.
#' @references M. Groppe, L. Niemöller, S. Hundrieser, D. Ventzke, A. Blob, S. Köster and A. Munk (2025). Optimal Transport Based Testing in Factorial Design.
#' arXiv preprint. \doi{10.48550/arXiv.2509.13970}.
#' @keywords internal
"_PACKAGE"

#' @importFrom Rcpp loadModule
#' @importFrom rrapply rrapply
#' @importFrom future.apply future_sapply future_replicate future_lapply
#' @importFrom transport transport
#' @useDynLib FDOTT, .registration = TRUE
NULL
