% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processing.R
\name{curateFAannotations}
\alias{curateFAannotations}
\title{Modify FA annotations}
\usage{
curateFAannotations(msbatch, faid, dmz = 10)
}
\arguments{
\item{msbatch}{annotated msbatch.}

\item{faid}{data frame with 7 columns (ID, FAid, Adducts, mz, RT, iniRT and
endRT) containing curated FAs.}

\item{dmz}{mz tolerance in ppm.}
}
\value{
annotated msbatch.
}
\description{
after FA annotation using \link{annotateFA}, the resulting
data frame can be modified to remove rows with unwanted annotation, iniRT and
endRT can be changed to redefine peak limits and extra rows may be written to
add new annotations. FAid should also be modified to contain unique names
such as "FA(16:1)n7" and "FA(16:1)n10" instead of generic "FA(16:1)". For
unknown fatty acids use FA(16:1)nx (nx, ny and nz are availables for all FA).

Internal standards can also be added to normalize data later. Leave ID and
Adducts columns empty, write "IS" at the FAid column and add mz, RT, iniRT
and endRT information.
}
\details{
Modify FA annotations
}
\examples{
\dontrun{
msbatch <- annotateFA(msbatch, dmz = 5)

plots <- plotFA(msbatch, dmz = 10)

pdf("FAs.pdf")
for (p in 1:length(plots)){
  print(plots[[p]])
}
dev.off()

write.csv(msbatch$fas, file="faid.csv", row.names=FALSE)

faid <- read.csv("faid_curated.csv", sep=",", dec=".")

msbatch <- curateFAannotations(msbatch, faid)
}

}
\author{
M Isabel Alcoriza-Balaguer <maribel_alcoriza@iislafe.es>
}
