\name{plotBayes}
\alias{plotBayes}
\title{Plot empirical Bayes inference results for continuous and discrete generalized Pareto distribution}
\usage{
plotBayes(
  x,
  mle,
  alpha = 0.05,
  param = c("scale", "shape"),
  cols = c("mediumseagreen", "goldenrod", "gold4"),
  ...
)
}
\arguments{
\item{x}{a vector of posterior samples}

\item{mle}{vector of length 2 containing the maximum likelihood estimator for the scale and shape parameters, respectively (only used if \code{param="scale"})}

\item{alpha}{level for intervals. Default to 0.05 giving 95\% confidence intervals}

\item{param}{character string indicating the parameter. Default: \code{c("scale", "shape")}}

\item{cols}{vector of length three containing colors for posterior mean, confidence intervals, and credible intervals. Default to \code{c("mediumseagreen", "goldenrod", "gold4")}}

\item{...}{additional arguments for plotting function; only \code{xlab} is allowed}
}
\value{
\code{NULL}; used to create a plot
}
\description{
Given a sample of posterior draws of the scale or shape parameter, return a histogram on the density scale for the posterior distribution along with a theoretical prior and posterior comparison curve based on the MLE, pointwise Wald-based normal 95\% confidence intervals for the mean of the sample, and pointwise credible intervals (asymmetric by design).
}
\examples{
\dontrun{
# generate data
set.seed(1234)
n <- 500
samp <- evd::rfrechet(n, 0, 3, 4)
# set effective sample size and threshold
k <- 50
threshold <- sort(samp, decreasing = TRUE)[k+1]
# preliminary mle estimates of scale and shape parameters
mlest <- evd::fpot(samp, threshold)
# empirical bayes procedure
proc <- estPOT(
 samp,
 k = k,
 pn = c(0.01, 0.005),
 type = "continuous",
 method = "bayesian",
 prior = "empirical",
 start = as.list(mlest$estimate),
 sig0 = 0.1)
plotBayes(
  proc$post_sample[,1],
  mlest$estimate,
  param = "scale")
plotBayes(
  proc$post_sample[,2],
  param = "shape")
}
}
