% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gamma.R
\name{Gamma}
\alias{Gamma}
\alias{dGamma}
\alias{pGamma}
\alias{qGamma}
\alias{rGamma}
\alias{eGamma}
\alias{lGamma}
\title{The Gamma Distribution.}
\usage{
dGamma(x, shape = 2, scale = 2, params = list(shape = 2, scale = 2), ...)

pGamma(q, shape = 2, scale = 2, params = list(shape = 2, scale = 2), ...)

qGamma(p, shape = 2, scale = 2, params = list(shape = 2, scale = 2), ...)

rGamma(n, shape = 2, scale = 2, params = list(shape = 2, scale = 2), ...)

eGamma(X, w, method = c("moments", "numerical.MLE"), ...)

lGamma(
  X,
  w,
  shape = 2,
  scale = 2,
  params = list(shape = 2, scale = 2),
  logL = TRUE,
  ...
)
}
\arguments{
\item{x, q}{A vector of quantiles.}

\item{shape}{Shape parameter.}

\item{scale}{Scale parameter.}

\item{params}{A list that includes all named parameters}

\item{...}{Additional parameters.}

\item{p}{A vector of probabilities.}

\item{n}{Number of observations.}

\item{X}{Sample observations.}

\item{w}{An optional vector of sample weights.}

\item{method}{Parameter estimation method.}

\item{logL}{logical; if TRUE, lBeta_ab gives the log-likelihood, otherwise the likelihood is given.}
}
\value{
dGamma gives the density, pGamma the distribution function,
qGamma the quantile function, rGamma generates random deviates, and
eGamma estimates the distribution parameters.lgamma provides the log-likelihood function.
}
\description{
Density, distribution, quantile, random number
generation, and parameter estimation functions for the gamma distribution with parameters \code{shape} and
\code{scale}. Parameter estimation can be based on a weighted or unweighted i.i.d sample and can be carried out
numerically.
}
\details{
The \code{dGamma()}, \code{pGamma()}, \code{qGamma()},and \code{rGamma()} functions serve as wrappers of the standard
\code{\link[stats]{dgamma}}, \code{\link[stats]{pgamma}}, \code{\link[stats]{qgamma}}, and \code{\link[stats]{rgamma}} functions
in the \pkg{\link{stats}} package. They allow for the parameters to be declared not only as
individual numerical values, but also as a list so parameter estimation can be carried out. \cr
\cr
The gamma distribution with parameter \code{shape}=\eqn{\alpha} and \code{scale}=\eqn{\beta} has probability density function,
\deqn{f(x)= (1/\beta^\alpha \Gamma(\alpha))x^{\alpha-1}e^{-x/\beta}}
 where \eqn{\alpha > 0} and \eqn{\beta > 0}. Parameter estimation can be performed using the method of moments
 as given by Johnson et.al (pp.356-357). \cr
 \cr
 The log-likelihood function of the gamma distribution is given by,
 \deqn{l(\alpha, \beta |x) = (\alpha -1) \sum_i ln(x_i) - \sum_i(x_i/\beta) -n\alpha ln(\beta) + n ln \Gamma(\alpha)}
 where \eqn{\Gamma} is the \link[base]{gamma} function. The score function is provided by Rice (2007), p.270.
}
\examples{
# Parameter estimation for a distribution with known shape parameters
X <- rGamma(n=500, shape=1.5, scale=0.5)
est.par <- eGamma(X, method="numerical.MLE"); est.par
plot(est.par)

#  Fitted density curve and histogram
den.x <- seq(min(X),max(X),length=100)
den.y <- dGamma(den.x,shape=est.par$shape,scale=est.par$scale)
hist(X, breaks=10, probability=TRUE, ylim = c(0,1.1*max(den.y)))
lines(den.x, den.y, col="blue")
lines(density(X), lty=2)

# Extracting shape or scale parameters
est.par[attributes(est.par)$par.type=="shape"]
est.par[attributes(est.par)$par.type=="scale"]

# Parameter estimation for a distribution with unknown shape parameters
# Example from:  Bury(1999) pp.225-226, parameter estimates as given by Bury are
# shape = 6.40 and scale=2.54.
data <- c(16, 11.6, 19.9, 18.6, 18, 13.1, 29.1, 10.3, 12.2, 15.6, 12.7, 13.1,
         19.2, 19.5, 23, 6.7, 7.1, 14.3, 20.6, 25.6, 8.2, 34.4, 16.1, 10.2, 12.3)
est.par <- eGamma(data, method="numerical.MLE"); est.par
plot(est.par)

# log-likelihood
lGamma(data,param = est.par)

# Evaluating the precision of the parameter estimates by the Hessian matrix
H <- attributes(est.par)$nll.hessian
var <- solve(H)
se <- sqrt(diag(var));se
}
\references{
Johnson, N. L., Kotz, S. and Balakrishnan, N. (1995) Continuous Univariate Distributions,
 volume 1, chapter 17, Wiley, New York.\cr
\cr
 Bury, K. (1999) Statistical Distributions in Engineering, Chapter 13, pp.225-226,
 Cambridge University Press.\cr
 \cr
 Rice, J.A. (2007) Mathematical Statistics and Data Analysis, 3rd Ed, Brookes/Cole.
}
\seealso{
\pkg{\link{ExtDist}} for other standard distributions.
}
\author{
Haizhen Wu and A. Jonathan R. Godfrey. \cr
Updates and bug fixes by Sarah Pirikahu, Oleksii Nikolaienko.
}
