% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HierarchicalMetaAnalysis.R
\name{generateBayesianHMAsettings}
\alias{generateBayesianHMAsettings}
\title{Generate settings for the Bayesian random-effects hierarchical meta-analysis model}
\usage{
generateBayesianHMAsettings(
  primaryEffectPriorStd = 1,
  secondaryEffectPriorStd = 1,
  globalExposureEffectPriorMean = c(0),
  globalExposureEffectPriorStd = c(2),
  primaryEffectPrecisionPrior = c(1, 1),
  secondaryEffectPrecisionPrior = c(1, 1),
  errorPrecisionPrior = c(1, 1),
  errorPrecisionStartValue = 1,
  includeSourceEffect = TRUE,
  includeExposureEffect = TRUE,
  exposureEffectCount = 1,
  separateExposurePrior = FALSE,
  chainLength = 1100000,
  burnIn = 1e+05,
  subSampleFrequency = 100
)
}
\arguments{
\item{primaryEffectPriorStd}{Standard deviation for the average outcome effect.}

\item{secondaryEffectPriorStd}{Standard deviation for the average data-source effect.}

\item{globalExposureEffectPriorMean}{Prior mean for the global main exposure effect;
can be a multiple entry vector if there are multiple outcomes of interest}

\item{globalExposureEffectPriorStd}{Prior standard deviation for the global main exposure effect;
can be a multiple entry vector if there are multiple outcomes of interest}

\item{primaryEffectPrecisionPrior}{Shape and scale for the gamma prior of the precision term in the
random effects model (normal) for individual outcome effects.}

\item{secondaryEffectPrecisionPrior}{Shape and scale for the gamma prior of the precision term in the
random effects model (normal) for individual data-source effects.}

\item{errorPrecisionPrior}{Shape and scale for the gamma prior of the precision term in the
normal model for random errors.}

\item{errorPrecisionStartValue}{Initial value for the error distribution's precision term.}

\item{includeSourceEffect}{Whether or not to consider the data-source-specific (secondary) random effects. Default is TRUE.}

\item{includeExposureEffect}{Whether or not to estimate the main effect of interest. Default is TRUE.}

\item{exposureEffectCount}{Number of main outcomes of interest to estimate effect for? Default = 1}

\item{separateExposurePrior}{Use a separable prior on the main exposure effect? Default is FALSE.}

\item{chainLength}{Number of MCMC iterations.}

\item{burnIn}{Number of MCMC iterations to consider as burn in.}

\item{subSampleFrequency}{Subsample ("thinning") frequency for the MCMC.}
}
\value{
A list with all the settings to use in the \code{computeHierarchicalMetaAnalysis()} function.
}
\description{
This function generates a settings list for fitting a Bayesian hierarchical meta-analysis model.
See \code{computeHierarchicalMetaAnalysis()} for more details.
}
\seealso{
\link{computeHierarchicalMetaAnalysis}
}
