% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resample.r
\name{resample}
\alias{resample}
\alias{resample,Epoch-method}
\title{Generic function for resampling objects}
\usage{
resample(x, ...)

\S4method{resample}{Epoch}(x, samplingRate, ...)
}
\arguments{
\item{x}{An \code{Epoch} object to be resampled.}

\item{...}{Additional arguments passed to \code{gsignal::resample}}

\item{samplingRate}{The new sampling frequency (unit: Hertz).}
}
\value{
An \code{Epoch} object with the resampled data.
}
\description{
This function allows you to resample an object to a different sampling frequency.

This function allows you to resample an Epoch object to a different sampling frequency.
}
\examples{
# Create an Epoch object
epoch_data <- matrix(rnorm(1000), nrow = 10)
rownames(epoch_data) <- paste0("Electrode_", 1:10)
epoch <- Epoch(epoch_data, startTime = 0, samplingRate = 100)

# downsample the epoch to 50 Hz
resample(epoch, samplingRate = 50)

# upsample the epoch to 200 Hz
resample(epoch, samplingRate = 200)

}
\seealso{
Other Epoch methods: 
\code{\link{coltimes}()},
\code{\link{crop}()},
\code{\link{plot,Epoch,missing-method}},
\code{\link{show,Epoch-method}}
}
\concept{Epoch methods}
