% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AP_insect_simulator.R
\name{AP_insect_simulator}
\alias{AP_insect_simulator}
\title{Simulate AP assay data for individual insects}
\usage{
AP_insect_simulator(lmark_in, smarkpams_in, isVerbose, virusType)
}
\arguments{
\item{lmark_in}{Numeric vector of length 3 specifying assay durations.}

\item{smarkpams_in}{Numeric vector of length 4 specifying virus parameters (rates per hour):
The first element specifies the acquisition rate,
the second the inoculation rate,
the third the latent progression rate; code -1 for SPT
the forth the insect recovery rate}

\item{isVerbose}{Logical (default: FALSE). If TRUE, prints information from nested functions.}

\item{virusType}{Character. Plant virus type, either SPT or PT.}
}
\value{
A numeric vector of length 2:
\describe{
\item{\code{[1]}}{Binary infection status of the test plant (1 = infected, 0 = not infected).}
\item{\code{[2]}}{Number of virus re-acquisition events (relevant for SPT viruses).}
}
}
\description{
Simulates AP experiment data by modeling each insect's virus acquisition, latency, recovery, and inoculation independently.
}
\details{
AP insect simulator models insects in AP assays as acquiring virus, progressing through latency, recovering, and inoculating independently.
Since acquisition can happen in the initial period, latency progression may occur either within the acquisition period, during the latency-specific period,
or in the inoculation period, affecting the final inoculation time. The function outputs whether an insect successfully inoculates a test plant
and the number of virus re-acquisition events (for SPT viruses).
}
\keyword{internal}
