% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EValue.R
\name{evalues.RR}
\alias{evalues.RR}
\title{Compute E-value for a risk ratio or rate ratio and its confidence interval
limits}
\usage{
evalues.RR(est, lo = NA, hi = NA, true = 1, ...)
}
\arguments{
\item{est}{The point estimate}

\item{lo}{The lower limit of the confidence interval}

\item{hi}{The upper limit of the confidence interval}

\item{true}{The true RR to which to shift the observed point estimate.
Typically set to 1 to consider a null true effect.}

\item{...}{Arguments passed to other methods.}
}
\description{
Returns a data frame containing point estimates, the lower confidence limit,
and the upper confidence limit for the risk ratio (as provided by the user)
as well as E-values for the point estimate and the confidence interval limit
closer to the null.
}
\examples{
# compute E-value for leukemia example in VanderWeele and Ding (2017)
evalues.RR(0.80, 0.71, 0.91)

# you can also pass just the point estimate
evalues.RR(0.80)

# demonstrate symmetry of E-value
# this apparently causative association has same E-value as the above
evalues.RR(1 / 0.80)
}
\keyword{e-value}
