% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ETDQualitizer.R
\name{DataQuality}
\alias{DataQuality}
\title{R6 class for calculating Data Quality from a gaze data segment}
\description{
Provides methods for assessing the quality of gaze data, including accuracy, precision, data loss, and effective sampling frequency.
}
\examples{
sc <- ScreenConfiguration$new(500, 300, 1920, 1080, 600)
gaze_x <- c(0, 1, -1)
gaze_y <- c(0, 1, -1)
timestamps <- c(0, 1, 2)
dq <- DataQuality$new(gaze_x, gaze_y, timestamps, unit = "pixels", screen = sc)
dq$accuracy(0, 0)
dq$precision_RMS_S2S()
dq$data_loss_from_invalid()


## ------------------------------------------------
## Method `DataQuality$new`
## ------------------------------------------------

dq <- DataQuality$new(gaze_x, gaze_y, timestamps, unit = "pixels", screen = sc)

## ------------------------------------------------
## Method `DataQuality$accuracy`
## ------------------------------------------------

dq$accuracy(0, 0)

## ------------------------------------------------
## Method `DataQuality$precision_RMS_S2S`
## ------------------------------------------------

dq$precision_RMS_S2S()

## ------------------------------------------------
## Method `DataQuality$precision_STD`
## ------------------------------------------------

dq$precision_STD()

## ------------------------------------------------
## Method `DataQuality$precision_BCEA`
## ------------------------------------------------

dq$precision_BCEA()

## ------------------------------------------------
## Method `DataQuality$data_loss_from_invalid`
## ------------------------------------------------

dq$data_loss_from_invalid()

## ------------------------------------------------
## Method `DataQuality$data_loss_from_expected`
## ------------------------------------------------

dq$data_loss_from_expected(500)

## ------------------------------------------------
## Method `DataQuality$effective_frequency`
## ------------------------------------------------

dq$effective_frequency()

## ------------------------------------------------
## Method `DataQuality$get_duration`
## ------------------------------------------------

dq$get_duration()

## ------------------------------------------------
## Method `DataQuality$precision_using_moving_window`
## ------------------------------------------------

dq$precision_using_moving_window(0.2, "RMS-S2S")
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{timestamps}}{Vector of timestamps in seconds. Samples with missing data should not be removed, or the RMS calculation would be incorrect.}

\item{\code{azi}}{Vector of azimuth angles in degrees (Fick angles). Missing data should be coded as NA, not using some special value such as (0,0) or (-xres,-yres).}

\item{\code{ele}}{Vector of elevation angles in degrees (Fick angles). Missing data should be coded as NA, not using some special value such as (0,0) or (-xres,-yres).}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-DataQuality-new}{\code{DataQuality$new()}}
\item \href{#method-DataQuality-accuracy}{\code{DataQuality$accuracy()}}
\item \href{#method-DataQuality-precision_RMS_S2S}{\code{DataQuality$precision_RMS_S2S()}}
\item \href{#method-DataQuality-precision_STD}{\code{DataQuality$precision_STD()}}
\item \href{#method-DataQuality-precision_BCEA}{\code{DataQuality$precision_BCEA()}}
\item \href{#method-DataQuality-data_loss_from_invalid}{\code{DataQuality$data_loss_from_invalid()}}
\item \href{#method-DataQuality-data_loss_from_expected}{\code{DataQuality$data_loss_from_expected()}}
\item \href{#method-DataQuality-effective_frequency}{\code{DataQuality$effective_frequency()}}
\item \href{#method-DataQuality-get_duration}{\code{DataQuality$get_duration()}}
\item \href{#method-DataQuality-precision_using_moving_window}{\code{DataQuality$precision_using_moving_window()}}
\item \href{#method-DataQuality-clone}{\code{DataQuality$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataQuality-new"></a>}}
\if{latex}{\out{\hypertarget{method-DataQuality-new}{}}}
\subsection{Method \code{new()}}{
Creates a new DataQuality object from gaze data and timestamps.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataQuality$new(gaze_x, gaze_y, timestamps, unit, screen = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{gaze_x}}{Horizontal gaze positions (pixels or degrees).}

\item{\code{gaze_y}}{Vertical gaze positions (pixels or degrees).}

\item{\code{timestamps}}{Vector of timestamps in seconds.}

\item{\code{unit}}{Unit of gaze data: either \code{"pixels"} or \code{"degrees"}.}

\item{\code{screen}}{Optional \code{ScreenConfiguration} object, required if unit is \code{"pixels"}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new DataQuality object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{dq <- DataQuality$new(gaze_x, gaze_y, timestamps, unit = "pixels", screen = sc)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataQuality-accuracy"></a>}}
\if{latex}{\out{\hypertarget{method-DataQuality-accuracy}{}}}
\subsection{Method \code{accuracy()}}{
Calculates the accuracy of gaze data relative to a known target location.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataQuality$accuracy(target_azi, target_ele, central_tendency_fun = mean)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{target_azi}}{Target azimuth in degrees.}

\item{\code{target_ele}}{Target elevation in degrees.}

\item{\code{central_tendency_fun}}{Function to compute central tendency (e.g., \code{mean}, \code{median}).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Accuracy in degrees.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{dq$accuracy(0, 0)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataQuality-precision_RMS_S2S"></a>}}
\if{latex}{\out{\hypertarget{method-DataQuality-precision_RMS_S2S}{}}}
\subsection{Method \code{precision_RMS_S2S()}}{
Calculates precision as root mean square of sample-to-sample distances
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataQuality$precision_RMS_S2S(central_tendency_fun = mean)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{central_tendency_fun}}{Function to compute central tendency (e.g., \code{mean}, \code{median}).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Precision in degrees.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{dq$precision_RMS_S2S()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataQuality-precision_STD"></a>}}
\if{latex}{\out{\hypertarget{method-DataQuality-precision_STD}{}}}
\subsection{Method \code{precision_STD()}}{
Calculates precision as standard deviation of gaze positions.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataQuality$precision_STD()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Standard deviation in degrees.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{dq$precision_STD()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataQuality-precision_BCEA"></a>}}
\if{latex}{\out{\hypertarget{method-DataQuality-precision_BCEA}{}}}
\subsection{Method \code{precision_BCEA()}}{
Calculates the Bivariate Contour Ellipse Area (BCEA) and ellipse parameters for gaze precision.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataQuality$precision_BCEA(P = 0.68)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{P}}{Proportion of data to include in the ellipse (default is 0.68).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
BCEA in degrees-squared.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{dq$precision_BCEA()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataQuality-data_loss_from_invalid"></a>}}
\if{latex}{\out{\hypertarget{method-DataQuality-data_loss_from_invalid}{}}}
\subsection{Method \code{data_loss_from_invalid()}}{
Calculates the proportion of missing data (coded as NA).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataQuality$data_loss_from_invalid()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Proportion of missing samples.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{dq$data_loss_from_invalid()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataQuality-data_loss_from_expected"></a>}}
\if{latex}{\out{\hypertarget{method-DataQuality-data_loss_from_expected}{}}}
\subsection{Method \code{data_loss_from_expected()}}{
Estimates data loss based on expected number of samples given the duration and sampling frequency.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataQuality$data_loss_from_expected(frequency)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{frequency}}{Expected sampling frequency in Hz.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Proportion of missing samples.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{dq$data_loss_from_expected(500)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataQuality-effective_frequency"></a>}}
\if{latex}{\out{\hypertarget{method-DataQuality-effective_frequency}{}}}
\subsection{Method \code{effective_frequency()}}{
Calculates the effective sampling frequency based on timestamps.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataQuality$effective_frequency()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Effective frequency in Hz.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{dq$effective_frequency()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataQuality-get_duration"></a>}}
\if{latex}{\out{\hypertarget{method-DataQuality-get_duration}{}}}
\subsection{Method \code{get_duration()}}{
Computes the total duration of the gaze recording, including the last sample.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataQuality$get_duration()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Duration in seconds.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{dq$get_duration()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataQuality-precision_using_moving_window"></a>}}
\if{latex}{\out{\hypertarget{method-DataQuality-precision_using_moving_window}{}}}
\subsection{Method \code{precision_using_moving_window()}}{
Calculates precision using a moving window approach.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataQuality$precision_using_moving_window(
  window_length,
  metric,
  aggregation_fun = median,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{window_length}}{Length of the moving window in number of samples.}

\item{\code{metric}}{Precision metric to use (\code{"RMS-S2S"}, \code{"STD"}, or \code{"BCEA"}).}

\item{\code{aggregation_fun}}{Function to aggregate windowed precision values (e.g., \code{median}).}

\item{\code{...}}{Additional arguments passed to the precision metric function.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Precision value.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{dq$precision_using_moving_window(0.2, "RMS-S2S")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataQuality-clone"></a>}}
\if{latex}{\out{\hypertarget{method-DataQuality-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataQuality$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
