% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/background.buffer.R
\name{background.buffer}
\alias{background.buffer}
\title{Takes a set of points, a buffer radius, a buffer type, and a mask and returns
either a raster, a polygon, or background points representing the species background.
Code modified from Elith and Hijmans SDM with R tutorial}
\usage{
background.buffer(
  points,
  buffer.width,
  buffer.type = "circles",
  mask = NA,
  return.type = "raster",
  n = 1000
)
}
\arguments{
\item{points}{A two column data frame with X and Y coordinates}

\item{buffer.width}{Radius for circular buffers to draw around points, for buffer.type = circular.  If buffer.type = "convhull", denotes the amount to which the initial polygon should be buffered.  It's worth noting that this argument may in some cases be treated as map units (e.g., lat and long), but in other caess may be treated as meters.  If you're getting weird behavior, you might try changing the units you're using to specify buffer.width.}

\item{buffer.type}{Which method to use for buffering species occurrence points.  Currently accepts "circles" and "convhull".}

\item{mask}{A raster to use as a mask for trimming the buffer if the return type is "raster" or "points"}

\item{return.type}{What type of object to return.  Can be "raster", "polygon", or "points".}

\item{n}{Sample size for number of background points to return, for return.type = "points".}
}
\value{
Either a raster, a polygon, or a data frame of points representing the species background.
}
\description{
Takes a set of points, a buffer radius, a buffer type, and a mask and returns
either a raster, a polygon, or background points representing the species background.
Code modified from Elith and Hijmans SDM with R tutorial
}
