% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{ibs_cam_trials_df}
\alias{ibs_cam_trials_df}
\title{Studies on CAM for Irritable Bowel Syndrome}
\format{
A data frame with 19 observations and 12 variables:
\describe{
  \item{id}{Integer trial identifier}
  \item{study}{Character study name/location}
  \item{year}{Integer publication year}
  \item{country}{Character country where study was conducted}
  \item{ibs.crit}{Character IBS diagnostic criteria used}
  \item{days}{Integer study duration in days}
  \item{visits}{Integer number of study visits}
  \item{jadad}{Integer Jadad score for study quality}
  \item{x.a}{Integer active treatment events}
  \item{n.a}{Integer active treatment sample size}
  \item{x.p}{Integer placebo group events}
  \item{n.p}{Integer placebo group sample size}
}
}
\source{
Data taken from the \pkg{metadat} package version 1.4-0.
}
\usage{
data(ibs_cam_trials_df)
}
\description{
This dataset, ibs_cam_trials_df, is a data frame containing results from 19 clinical trials
examining complementary and alternative medicine (CAM) interventions for irritable bowel syndrome (IBS).
The dataset includes 12 variables characterizing each trial and its outcomes.
}
\details{
The dataset name has been kept as 'ibs_cam_trials_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
DigestiveDataSets package and assists users in identifying its specific characteristics.
The suffix 'df' indicates that the dataset is a data frame. The original content has not been modified
in any way.
}
